/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.warmup.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.warmup.util.LoggingKt;
import com.intellij.warmup.util.StructuredMessage;
import com.intellij.warmup.util.WarmupLoggingService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/warmup/util/ChannelingProgressIndicator;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "prefix", "", "(Ljava/lang/String;)V", "offerState", "", "setFraction", "fraction", "", "setIndeterminate", "indeterminate", "", "setText", "text", "setText2", "intellij.platform.warmup"})
@SourceDebugExtension(value={"SMAP\nlogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 logging.kt\ncom/intellij/warmup/util/ChannelingProgressIndicator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,252:1\n30#2,3:253\n*S KotlinDebug\n*F\n+ 1 logging.kt\ncom/intellij/warmup/util/ChannelingProgressIndicator\n*L\n127#1:253,3\n*E\n"})
final class ChannelingProgressIndicator
extends ProgressIndicatorBase {
    @NotNull
    private final String prefix;

    public ChannelingProgressIndicator(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
    }

    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.offerState();
    }

    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.offerState();
    }

    public void setText(@Nullable String text2) {
        super.setText(text2);
        super.setText2("");
        this.offerState();
    }

    public void setText2(@Nullable String text2) {
        super.setText2(text2);
        this.offerState();
    }

    private final void offerState() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<WarmupLoggingService> serviceClass$iv = WarmupLoggingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        MutableSharedFlow<StructuredMessage> messages = ((WarmupLoggingService)object).getMessages();
        StructuredMessage structuredMessage = LoggingKt.progressStateText(LoggingKt.access$dumpProgressState((ProgressIndicator)this));
        if (structuredMessage == null) {
            return;
        }
        StructuredMessage progressState = structuredMessage;
        String actualPrefix = ((CharSequence)this.prefix).length() == 0 ? "" : "[" + this.prefix + "]: ";
        String string2 = actualPrefix + progressState.getContractedMessage();
        messages.tryEmit((Object)progressState.copy(actualPrefix + progressState.getFullMessage(), string2));
    }
}

