/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.vcs.log.util.StopWatchScopeKt;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public final class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private static final String[] UNIT_NAMES = new String[]{"s", "m", "h"};
    private static final long[] UNITS = new long[]{1L, 60L, 3600L};
    private static final String M_SEC_FORMAT = "%03d";
    private final long myStartTime;
    private final Span mySpan;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        if (operation == null) {
            StopWatch.$$$reportNull$$$0(0);
        }
        this.mySpan = TelemetryManager.getInstance().getTracer(StopWatchScopeKt.StopWatchScope).spanBuilder(operation).startSpan();
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = new HashMap<VirtualFile, Long>();
    }

    @NotNull
    public static StopWatch start(@NonNls @NotNull String operation) {
        if (operation == null) {
            StopWatch.$$$reportNull$$$0(1);
        }
        return new StopWatch(operation);
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        if (root == null) {
            StopWatch.$$$reportNull$$$0(2);
        }
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        if (durations == null) {
            StopWatch.$$$reportNull$$$0(3);
        }
        long sum2 = 0L;
        for (Long duration : durations) {
            sum2 += duration.longValue();
        }
        return sum2;
    }

    public void report() {
        this.report(LOG);
    }

    public void report(@NotNull Logger logger) {
        if (logger == null) {
            StopWatch.$$$reportNull$$$0(4);
        }
        this.mySpan.end();
        String message2 = this.myOperation + " took " + StopWatch.formatTime(System.currentTimeMillis() - this.myStartTime);
        if (this.myDurationPerRoot.size() > 1) {
            message2 = message2 + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), entry2 -> "    " + ((VirtualFile)entry2.getKey()).getName() + ": " + StopWatch.formatTime((Long)entry2.getValue()), (String)"\n");
        }
        logger.debug(message2);
    }

    @NotNull
    public static String formatTime(long time) {
        if (time < 1000L * UNITS[0]) {
            String string2 = time + "ms";
            if (string2 == null) {
                StopWatch.$$$reportNull$$$0(5);
            }
            return string2;
        }
        Object result2 = "";
        long remainder = time / 1000L;
        long msec = time % 1000L;
        for (int i = UNITS.length - 1; i >= 0; --i) {
            if (remainder < UNITS[i]) continue;
            long quotient = remainder / UNITS[i];
            remainder %= UNITS[i];
            if (i == 0) {
                result2 = (String)result2 + quotient + (String)(msec == 0L ? "" : "." + String.format(M_SEC_FORMAT, msec)) + UNIT_NAMES[i];
                continue;
            }
            result2 = (String)result2 + quotient + UNIT_NAMES[i];
            if (remainder == 0L && msec == 0L) continue;
            result2 = (String)result2 + " ";
            if (remainder != 0L) continue;
            result2 = (String)result2 + "0." + String.format(M_SEC_FORMAT, msec) + UNIT_NAMES[0];
        }
        String string3 = result2;
        if (string3 == null) {
            StopWatch.$$$reportNull$$$0(6);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/StopWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/StopWatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rootCompleted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }
}

