/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplacementPreviewDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ReplaceUsageViewContext
extends UsageViewContext {
    private final Map<Usage, ReplacementInfo> usage2ReplacementInfo;
    private final Replacer replacer;

    ReplaceUsageViewContext(@NotNull SearchContext context, @NotNull Configuration configuration, @NotNull Runnable searchStarter) {
        if (context == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(1);
        }
        if (searchStarter == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(2);
        }
        super(configuration, context, searchStarter);
        this.usage2ReplacementInfo = new HashMap<Usage, ReplacementInfo>();
        this.replacer = new Replacer(this.mySearchContext.getProject(), this.myConfiguration.getReplaceOptions());
    }

    public void addReplaceUsage(@NotNull Usage usage, @NotNull MatchResult result2) {
        if (usage == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(4);
        }
        this.usage2ReplacementInfo.put(usage, this.replacer.buildReplacement(result2));
    }

    private static boolean isValid(@NotNull UsageInfo2UsageAdapter info) {
        PsiElement element;
        if (info == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(5);
        }
        return (element = info.getUsageInfo().getElement()) != null && element.isValid();
    }

    @Override
    protected void configureActions() {
        super.configureActions();
        this.myUsageView.addButtonToLowerPane(() -> this.replace(this.myUsageView.getSortedUsages()), SSRBundle.message("do.replace.all.button", new Object[0]));
        this.myUsageView.addButtonToLowerPane(() -> this.replace(this.myUsageView.getSelectedUsages()), SSRBundle.message("replace.selected.button", new Object[0]));
        Runnable previewReplacement = () -> {
            Set selection = this.myUsageView.getSelectedUsages();
            if (selection.isEmpty()) {
                return;
            }
            for (Usage usage : selection) {
                UsageInfo2UsageAdapter info = (UsageInfo2UsageAdapter)usage;
                if (!ReplaceUsageViewContext.isValid(info) || this.myUsageView.getExcludedUsages().contains(usage)) continue;
                ReplacementInfo replacementInfo = this.usage2ReplacementInfo.get(usage);
                ReplacementPreviewDialog previewDialog = new ReplacementPreviewDialog(this.mySearchContext.getProject(), info.getUsageInfo(), replacementInfo.getReplacement());
                if (!previewDialog.showAndGet()) {
                    return;
                }
                this.replace(Collections.singleton(info));
            }
        };
        this.myUsageView.addButtonToLowerPane(previewReplacement, SSRBundle.message("preview.replacement.button", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(@NotNull Collection<? extends Usage> usages) {
        if (usages == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(6);
        }
        Set excluded = this.myUsageView.getExcludedUsages();
        usages = usages.stream().filter(u -> !excluded.contains(u)).filter(u -> ReplaceUsageViewContext.isValid((UsageInfo2UsageAdapter)u)).collect(Collectors.toList());
        List files2 = ContainerUtil.map((Collection)usages, i -> ((UsageInFile)i).getFile());
        if (ReadonlyStatusHandler.getInstance((Project)this.mySearchContext.getProject()).ensureFilesWritable((Collection)files2).hasReadonlyFiles()) {
            return;
        }
        this.removeUsagesAndSelectNext(usages, excluded);
        List replacementInfos = ContainerUtil.map((Collection)usages, this.usage2ReplacementInfo::get);
        LocalHistoryAction action2 = LocalHistory.getInstance().startAction(SSRBundle.message("structural.replace.title", new Object[0]));
        try {
            CommandProcessor.getInstance().executeCommand(this.mySearchContext.getProject(), () -> this.replacer.replaceAll(replacementInfos), SSRBundle.message("structural.replace.title", new Object[0]), null);
        }
        finally {
            action2.finish();
        }
    }

    private void removeUsagesAndSelectNext(@NotNull Collection<? extends Usage> usages, @NotNull Collection<? extends Usage> excluded) {
        List sortedUsages;
        if (usages == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(7);
        }
        if (excluded == null) {
            ReplaceUsageViewContext.$$$reportNull$$$0(8);
        }
        if ((sortedUsages = this.myUsageView.getSortedUsages()).size() == usages.size()) {
            this.myUsageView.close();
        } else {
            Usage firstValid = null;
            Usage select = null;
            for (Usage usage : sortedUsages) {
                if (usages.contains(usage)) {
                    select = null;
                    continue;
                }
                if (excluded.contains(usage) || !ReplaceUsageViewContext.isValid((UsageInfo2UsageAdapter)usage)) continue;
                if (select == null) {
                    select = usage;
                }
                if (firstValid != null) continue;
                firstValid = usage;
            }
            this.myUsageView.removeUsagesBulk(usages);
            this.myUsageView.selectUsages(new Usage[]{(Usage)ObjectUtils.coalesce(select, firstValid, (Object)((Usage)this.myUsageView.getSortedUsages().get(0)))});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchStarter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/ui/ReplaceUsageViewContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addReplaceUsage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isValid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeUsagesAndSelectNext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

