/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListCompletionContributor;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeListChooserPanel
extends JPanel {
    private final MyEditorComboBox myExistingListsCombo;
    private final NewEditChangelistPanel myListPanel;
    private final Consumer<? super String> myOkEnabledListener;
    private final Project myProject;
    private String myLastTypedDescription;
    private boolean myNewNameSuggested;
    @Nullable
    private ChangeListData myData;

    public ChangeListChooserPanel(Project project2, @NotNull Consumer<? super @Nullable String> okEnabledListener) {
        if (okEnabledListener == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myNewNameSuggested = false;
        this.myProject = project2;
        this.myExistingListsCombo = new MyEditorComboBox();
        this.myExistingListsCombo.setEditable(true);
        this.myExistingListsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ChangeList>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ChangeList> list2, ChangeList value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 != null) {
                    this.append(value2.getName(), value2 instanceof LocalChangeList && ((LocalChangeList)value2).isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$1", "customizeCellRenderer"));
            }
        });
        this.myListPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected NewEditChangelistPanel.ComponentWithTextFieldWrapper createComponentWithTextField(Project project2) {
                return new NewEditChangelistPanel.ComponentWithTextFieldWrapper((JComponent)((Object)ChangeListChooserPanel.this.myExistingListsCombo)){

                    @Override
                    @NotNull
                    public EditorTextField getEditorTextField() {
                        EditorTextField editorTextField = ChangeListChooserPanel.this.myExistingListsCombo.getEditorTextField();
                        if (editorTextField == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return editorTextField;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$2$1", "getEditorTextField"));
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @RequiresEdt
            protected void nameChanged(String string2) {
                void errorMessage;
                ApplicationManager.getApplication().assertIsDispatchThread();
                ApplicationManager.getApplication().invokeLater(() -> ChangeListChooserPanel.this.updateDescription(), ModalityState.current());
                ChangeListChooserPanel.this.myOkEnabledListener.accept((String)errorMessage);
            }

            @Override
            public void init(@Nullable LocalChangeList initial) {
                super.init(initial);
                this.descriptionTextArea.addFocusListener((FocusListener)new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        super.focusLost(e);
                        if (ChangeListChooserPanel.this.getExistingChangelistByName(ChangeListChooserPanel.this.myListPanel.getChangeListName()) == null) {
                            ChangeListChooserPanel.this.myLastTypedDescription = ChangeListChooserPanel.this.myListPanel.getDescription();
                        }
                    }
                });
            }

            @Override
            protected void nameChangedImpl(@Nullable LocalChangeList initial) {
                this.nameChanged(StringUtil.isEmptyOrSpaces((String)this.getChangeListName()) ? VcsBundle.message("new.changelist.empty.name.error", new Object[0]) : null);
            }
        };
        this.myOkEnabledListener = okEnabledListener;
        this.add((Component)((Object)this.myListPanel), "Center");
        this.setChangeLists(null);
        this.setDefaultSelection(null);
    }

    public void init() {
        this.myListPanel.init(null);
    }

    public void setChangeLists(@Nullable Collection<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            changeLists = ChangeListManager.getInstance(this.myProject).getChangeLists();
        }
        this.myExistingListsCombo.setModel(new DefaultComboBoxModel<ChangeList>(changeLists.toArray(new ChangeList[0])));
    }

    public void setSuggestedName(@NlsSafe @NotNull String name) {
        if (name == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(1);
        }
        this.setSuggestedName(name, false);
    }

    public void setSuggestedName(@NlsSafe @NotNull String name, boolean forceCreate) {
        if (name == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(2);
        }
        this.setSuggestedName(name, null, forceCreate);
    }

    public void setSuggestedName(@NlsSafe @NotNull String name, @Nls @Nullable String comment, boolean forceCreate) {
        if (name == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        LocalChangeList changelistByName = this.getExistingChangelistByName(name);
        if (changelistByName != null) {
            this.myExistingListsCombo.setSelectedItem(changelistByName);
        } else if (forceCreate || VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY) {
            this.myNewNameSuggested = true;
            this.myExistingListsCombo.insertItemAt(LocalChangeList.createEmptyChangeList(this.myProject, name), 0);
            if (StringUtil.isEmptyOrSpaces((String)this.myLastTypedDescription)) {
                this.myLastTypedDescription = comment;
            }
            if (VcsConfiguration.getInstance((Project)this.myProject).PRESELECT_EXISTING_CHANGELIST) {
                this.selectActiveChangeListIfExist();
            } else {
                this.myListPanel.setChangeListName(name);
            }
        }
        this.updateDescription();
    }

    private void selectActiveChangeListIfExist() {
        this.myExistingListsCombo.setSelectedItem(ChangeListManager.getInstance(this.myProject).getDefaultChangeList());
    }

    public void setData(@Nullable ChangeListData data2) {
        this.myData = data2;
    }

    public void updateEnabled() {
        if (this.myProject != null) {
            this.myListPanel.nameChangedImpl(null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project2) {
        String changeListName;
        ChangeListManagerEx manager = ChangeListManagerEx.getInstanceEx(project2);
        LocalChangeList localChangeList = manager.findChangeList(changeListName = this.myListPanel.getChangeListName());
        if (localChangeList == null) {
            localChangeList = manager.addChangeList(changeListName, this.myListPanel.getDescription(), this.myData);
            this.myListPanel.changelistCreatedOrChanged(localChangeList);
        } else {
            manager.editComment(changeListName, this.myListPanel.getDescription());
        }
        this.rememberSettings(project2, localChangeList.isDefault(), this.myListPanel.getMakeActiveCheckBox().isSelected());
        if (this.myListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(localChangeList);
        }
        return localChangeList;
    }

    private void rememberSettings(@NotNull Project project2, boolean activeListSelected, boolean setActive) {
        if (project2 == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(4);
        }
        if (this.myNewNameSuggested) {
            VcsConfiguration.getInstance((Project)project2).PRESELECT_EXISTING_CHANGELIST = activeListSelected;
        }
        VcsConfiguration.getInstance((Project)project2).MAKE_NEW_CHANGELIST_ACTIVE = setActive;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.selectActiveChangeListIfExist();
        } else {
            this.myExistingListsCombo.setSelectedItem(defaultSelection);
        }
        this.updateDescription();
        this.updateEnabled();
    }

    private void updateDescription() {
        String newText;
        LocalChangeList list2 = this.getExistingChangelistByName(this.myListPanel.getChangeListName());
        String string2 = newText = list2 != null ? list2.getComment() : this.myLastTypedDescription;
        if (!StringUtil.equals((CharSequence)this.myListPanel.getDescription(), (CharSequence)newText)) {
            this.myListPanel.setDescription(newText);
        }
    }

    private LocalChangeList getExistingChangelistByName(@NotNull String changeListName) {
        if (changeListName == null) {
            ChangeListChooserPanel.$$$reportNull$$$0(5);
        }
        ChangeListManager manager = ChangeListManager.getInstance(this.myProject);
        return manager.findChangeList(changeListName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExistingListsCombo.getEditorTextField();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okEnabledListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuggestedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExistingChangelistByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEditorComboBox
    extends ComboBox<ChangeList> {
        private static final int PREF_WIDTH = 200;
        private final LanguageTextField myEditorTextField;

        MyEditorComboBox() {
            super(200);
            JBColor fg = new JBColor(46397, 7054941);
            JBColor bg = new JBColor(15465713, 3226418);
            TextIcon icon2 = new TextIcon(VcsBundle.message("new.changelist.new.label", new Object[0]), (Color)fg, (Color)bg, JBUIScale.scale((int)2));
            icon2.setFont(RelativeFont.TINY.derive(this.getFont()));
            icon2.setRound(JBUIScale.scale((int)4));
            JLabel label2 = new JLabel((Icon)icon2);
            final JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(true);
            panel2.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)4));
            panel2.add((Component)label2, "Center");
            this.myEditorTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, ChangeListChooserPanel.this.myProject, "");
            this.myEditorTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    String changeListName;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    panel2.setVisible(!StringUtil.isEmptyOrSpaces((String)(changeListName = e.getDocument().getText())) && ChangeListChooserPanel.this.getExistingChangelistByName(changeListName) == null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox$1", "documentChanged"));
                }
            });
            Objects.requireNonNull(this.myEditorTextField.getDocument()).putUserData(ChangeListCompletionContributor.COMBO_BOX_KEY, (Object)this);
            ComboBoxCompositeEditor compositeEditor = new ComboBoxCompositeEditor((JComponent)this.myEditorTextField, new JComponent[]{panel2});
            this.myEditorTextField.addSettingsProvider(editor -> {
                Color editorBackgroundColor = editor.getBackgroundColor();
                panel2.setBackground(editorBackgroundColor);
                compositeEditor.setBackground(editorBackgroundColor);
            });
            this.setEditor((ComboBoxEditor)compositeEditor);
        }

        @NotNull
        private EditorTextField getEditorTextField() {
            LanguageTextField languageTextField = this.myEditorTextField;
            if (languageTextField == null) {
                MyEditorComboBox.$$$reportNull$$$0(0);
            }
            return languageTextField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox", "getEditorTextField"));
        }
    }
}

