/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer2 == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (settingsType == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_BRACES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"});
            consumer2.renameStandardOption("SPACE_WITHIN_BRACES", JsonBundle.message("formatter.space_within_braces.label", new Object[0]));
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "SPACE_BEFORE_COLON", JsonBundle.message("formatter.space_before_colon.label", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "SPACE_AFTER_COLON", JsonBundle.message("formatter.space_after_colon.label", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES"});
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "KEEP_TRAILING_COMMA", JsonBundle.message("formatter.trailing_comma.label", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP, new Object[0]);
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "ARRAY_WRAPPING", JsonBundle.message("formatter.wrapping_arrays.label", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "OBJECT_WRAPPING", JsonBundle.message("formatter.objects.label", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer2.showCustomOption(JsonCodeStyleSettings.class, "PROPERTY_ALIGNMENT", JsonBundle.message("formatter.align.properties.caption", new Object[0]), JsonBundle.message("formatter.objects.label", new Object[0]), new Object[]{Holder.ALIGN_OPTIONS, Holder.ALIGN_VALUES});
        }
    }

    @NotNull
    public Language getLanguage() {
        JsonLanguage jsonLanguage = JsonLanguage.INSTANCE;
        if (jsonLanguage == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return jsonLanguage;
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return "{\n    \"json literals are\": {\n        \"strings\": [\"foo\", \"bar\", \"\\u0062\\u0061\\u0072\"],\n        \"numbers\": [42, 6.62606975e-34],\n        \"boolean values\": [true, false,],\n        \"objects\": {\"null\": null,\"another\": null,}\n    }\n}";
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        indentOptions.INDENT_SIZE = 2;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 0;
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (field == null) {
            JsonLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (codeStyleObject instanceof JsonCodeStyleSettings && field.getName().equals("PROPERTY_ALIGNMENT")) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{JsonCodeStyleSettings.PropertyAlignment.DO_NOT_ALIGN.getId(), JsonCodeStyleSettings.PropertyAlignment.ALIGN_ON_VALUE.getId(), JsonCodeStyleSettings.PropertyAlignment.ALIGN_ON_COLON.getId()}, new String[]{"do_not_align", "align_on_value", "align_on_colon"});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/formatter/JsonLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/formatter/JsonLanguageCodeStyleSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    private static final class Holder {
        private static final String[] ALIGN_OPTIONS = (String[])Arrays.stream(JsonCodeStyleSettings.PropertyAlignment.values()).map(alignment -> alignment.getDescription()).toArray(String[]::new);
        private static final int[] ALIGN_VALUES = ArrayUtil.toIntArray((Collection)ContainerUtil.map((Object[])JsonCodeStyleSettings.PropertyAlignment.values(), alignment -> alignment.getId()));
        private static final String SAMPLE = "{\n    \"json literals are\": {\n        \"strings\": [\"foo\", \"bar\", \"\\u0062\\u0061\\u0072\"],\n        \"numbers\": [42, 6.62606975e-34],\n        \"boolean values\": [true, false,],\n        \"objects\": {\"null\": null,\"another\": null,}\n    }\n}";

        private Holder() {
        }
    }
}

