/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text2) {
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!JsonCopyPasteProcessor.isSupportedFile(file) || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return StringUtil.unescapeStringCharacters((String)StringUtil.replaceUnicodeEscapeSequences((String)text2));
    }

    @Nullable
    private static JsonStringLiteral getSingleElementFromSelectionOrNull(PsiFile file, int start2, int end) {
        PsiElement element = file.findElementAt(start2);
        JsonStringLiteral literalExpression = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class);
        if (literalExpression == null) {
            return null;
        }
        TextRange textRange = literalExpression.getTextRange();
        if (start2 <= textRange.getStartOffset() || end >= textRange.getEndOffset()) {
            return null;
        }
        String text2 = literalExpression.getText();
        if (!text2.startsWith("\"") || !text2.endsWith("\"")) {
            return null;
        }
        return literalExpression;
    }

    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file, Editor editor, String text2, RawText rawText) {
        int selectionEnd;
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string2 = text2;
            if (string2 == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string2;
        }
        if (!JsonCopyPasteProcessor.isSupportedFile(file)) {
            String string3 = text2;
            if (string3 == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string3;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null) {
            String string4 = text2;
            if (string4 == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string4;
        }
        String string5 = StringUtil.escapeStringCharacters((String)text2);
        if (string5 == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string5;
    }

    private static boolean isSupportedFile(PsiFile file) {
        return file instanceof JsonFile && file.isPhysical();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonCopyPasteProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonCopyPasteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

