/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectionDifferenceModel
extends FileDifferenceModel {
    private final SelectionCalculator myCalculator;
    private final Revision myLeftRevision;
    private final Revision myRightRevision;
    private final int myFrom;
    private final int myTo;

    public SelectionDifferenceModel(Project p, @NotNull IdeaGateway gw, @NotNull SelectionCalculator c, @NotNull Revision left, @NotNull Revision right, int from, int to, boolean editableRightContent) {
        if (gw == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(0);
        }
        if (c == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(1);
        }
        if (left == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(2);
        }
        if (right == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(3);
        }
        super(p, gw, editableRightContent);
        this.myCalculator = c;
        this.myLeftRevision = left;
        this.myRightRevision = right;
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeftRevision.findEntry();
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRightRevision.findEntry();
    }

    @Override
    protected boolean isLeftContentAvailable(@NotNull RevisionProcessingProgress p) {
        if (p == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(4);
        }
        return this.myCalculator.canCalculateFor(this.myLeftRevision, p);
    }

    @Override
    protected boolean isRightContentAvailable(@NotNull RevisionProcessingProgress p) {
        if (p == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(5);
        }
        return this.myCalculator.canCalculateFor(this.myRightRevision, p);
    }

    @Override
    @Nullable
    protected DiffContent getReadOnlyLeftDiffContent(@NotNull RevisionProcessingProgress p) {
        if (p == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(6);
        }
        return this.getDiffContent(this.myLeftRevision, p);
    }

    @Override
    @Nullable
    protected DiffContent getReadOnlyRightDiffContent(@NotNull RevisionProcessingProgress p) {
        if (p == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(7);
        }
        return this.getDiffContent(this.myRightRevision, p);
    }

    @Override
    @Nullable
    protected DiffContent getEditableRightDiffContent(@NotNull RevisionProcessingProgress p) {
        Entry rightEntry;
        if (p == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(8);
        }
        if ((rightEntry = this.getRightEntry()) == null) {
            return null;
        }
        Document d = this.myGateway.getDocument(rightEntry.getPath());
        if (d == null) {
            return null;
        }
        int fromOffset = d.getLineStartOffset(this.myFrom);
        int toOffset = d.getLineEndOffset(this.myTo);
        return DiffContentFactory.getInstance().createFragment(this.myProject, d, new TextRange(fromOffset, toOffset));
    }

    @Nullable
    private DocumentContent getDiffContent(@NotNull Revision r, RevisionProcessingProgress p) {
        Entry e;
        if (r == null) {
            SelectionDifferenceModel.$$$reportNull$$$0(9);
        }
        if ((e = r.findEntry()) == null) {
            return null;
        }
        String content = this.myCalculator.getSelectionFor(r, p).getBlockContent();
        VirtualFile virtualFile = this.myGateway.findVirtualFile(e.getPath());
        if (virtualFile != null) {
            return DiffContentFactory.getInstance().create(content, virtualFile);
        }
        FileType fileType = this.myGateway.getFileType(e.getName());
        return DiffContentFactory.getInstance().create(content, fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gw";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/ui/models/SelectionDifferenceModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeftContentAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRightContentAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getReadOnlyLeftDiffContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getReadOnlyRightDiffContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditableRightDiffContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getDiffContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

