/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.DateFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDifferenceModel {
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    private final boolean isRightContentCurrent;

    protected FileDifferenceModel(Project p, @NotNull IdeaGateway gw, boolean currentRightContent) {
        if (gw == null) {
            FileDifferenceModel.$$$reportNull$$$0(0);
        }
        this.myProject = p;
        this.myGateway = gw;
        this.isRightContentCurrent = currentRightContent;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        Entry e = this.getRightEntry();
        if (e == null) {
            e = this.getLeftEntry();
        }
        if (e == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)e.getPath());
    }

    @NlsContexts.Label
    public String getLeftTitle(@NotNull RevisionProcessingProgress p) {
        Entry leftEntry;
        if (p == null) {
            FileDifferenceModel.$$$reportNull$$$0(1);
        }
        if ((leftEntry = this.getLeftEntry()) == null) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        return FileDifferenceModel.formatTitle(leftEntry, this.isLeftContentAvailable(p));
    }

    @NlsContexts.Label
    public String getRightTitle(@NotNull RevisionProcessingProgress p) {
        Entry rightEntry;
        if (p == null) {
            FileDifferenceModel.$$$reportNull$$$0(2);
        }
        if ((rightEntry = this.getRightEntry()) == null) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        if (this.isRightContentAvailable(p)) {
            return this.isRightContentCurrent ? LocalHistoryBundle.message("current.revision", new Object[0]) : FileDifferenceModel.formatTitle(rightEntry, true);
        }
        return FileDifferenceModel.formatTitle(rightEntry, false);
    }

    @NlsContexts.Label
    private static String formatTitle(Entry e, boolean isAvailable) {
        String result2 = DateFormatUtil.formatDateTime((long)e.getTimestamp()) + " - " + e.getName();
        if (!isAvailable) {
            result2 = result2 + " - " + LocalHistoryBundle.message("content.not.available", new Object[0]);
        }
        return result2;
    }

    @Nullable
    protected abstract Entry getLeftEntry();

    @Nullable
    protected abstract Entry getRightEntry();

    @NotNull
    public DiffContent getLeftDiffContent(@NotNull RevisionProcessingProgress p) {
        DiffContent content;
        Entry leftEntry;
        if (p == null) {
            FileDifferenceModel.$$$reportNull$$$0(3);
        }
        if ((leftEntry = this.getLeftEntry()) == null) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            if (emptyContent == null) {
                FileDifferenceModel.$$$reportNull$$$0(4);
            }
            return emptyContent;
        }
        if (this.isLeftContentAvailable(p) && (content = this.getReadOnlyLeftDiffContent(p)) != null) {
            DiffContent diffContent = content;
            if (diffContent == null) {
                FileDifferenceModel.$$$reportNull$$$0(5);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        if (documentContent == null) {
            FileDifferenceModel.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    @NotNull
    public DiffContent getRightDiffContent(@NotNull RevisionProcessingProgress p) {
        Entry rightEntry;
        if (p == null) {
            FileDifferenceModel.$$$reportNull$$$0(7);
        }
        if ((rightEntry = this.getRightEntry()) == null) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            if (emptyContent == null) {
                FileDifferenceModel.$$$reportNull$$$0(8);
            }
            return emptyContent;
        }
        if (this.isRightContentAvailable(p)) {
            DiffContent content;
            DiffContent diffContent = content = this.isRightContentCurrent ? this.getEditableRightDiffContent(p) : this.getReadOnlyRightDiffContent(p);
            if (content != null) {
                DiffContent diffContent2 = content;
                if (diffContent2 == null) {
                    FileDifferenceModel.$$$reportNull$$$0(9);
                }
                return diffContent2;
            }
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        if (documentContent == null) {
            FileDifferenceModel.$$$reportNull$$$0(10);
        }
        return documentContent;
    }

    protected abstract boolean isLeftContentAvailable(@NotNull RevisionProcessingProgress var1);

    protected abstract boolean isRightContentAvailable(@NotNull RevisionProcessingProgress var1);

    @Nullable
    protected abstract DiffContent getReadOnlyLeftDiffContent(@NotNull RevisionProcessingProgress var1);

    @Nullable
    protected abstract DiffContent getReadOnlyRightDiffContent(@NotNull RevisionProcessingProgress var1);

    @Nullable
    protected abstract DiffContent getEditableRightDiffContent(@NotNull RevisionProcessingProgress var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gw";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/ui/models/FileDifferenceModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/ui/models/FileDifferenceModel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftDiffContent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightDiffContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLeftTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRightTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLeftDiffContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRightDiffContent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

