/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LocalHistoryEventDispatcher {
    private static final Key<Boolean> WAS_VERSIONED_KEY = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
    private final LocalHistoryFacade myVcs;
    private final IdeaGateway myGateway;
    private final DisposableWrapperList<BulkFileListener> myVfsEventListeners = new DisposableWrapperList();

    LocalHistoryEventDispatcher(LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
    }

    void startAction() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myVcs.forceBeginChangeSet();
    }

    void finishAction(@NlsContexts.Label String name) {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.endChangeSet(name);
    }

    private void beginChangeSet() {
        this.myVcs.beginChangeSet();
    }

    private void endChangeSet(@NlsContexts.Label String name) {
        this.myVcs.endChangeSet(name);
    }

    private void fileCreated(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.beginChangeSet();
        this.createRecursively(file);
        this.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LocalHistoryEventDispatcher.this.isVersioned(f)) {
                    LocalHistoryEventDispatcher.this.myVcs.created(LocalHistoryEventDispatcher.this.myGateway.getPathOrUrl(f), f.isDirectory());
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                if (f == null) {
                    1.$$$reportNull$$$0(1);
                }
                return LocalHistoryEventDispatcher.this.myGateway.isVersioned(f, true) ? IdeaGateway.loadAndIterateChildren(f) : IdeaGateway.iterateDBChildren(f);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "f";
                objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void beforeContentsChange(@NotNull VFileContentChangeEvent e) {
        VirtualFile f;
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(0);
        }
        if (!this.myGateway.areContentChangesVersioned(f = e.getFile())) {
            return;
        }
        Pair<StoredContent, Long> content = this.myGateway.acquireAndUpdateActualContent(f, null);
        if (content != null) {
            this.myVcs.contentChanged(this.myGateway.getPathOrUrl(f), (Content)content.first, (Long)content.second);
        }
    }

    private void handleBeforeEvent(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            this.beforeContentsChange((VFileContentChangeEvent)event);
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename() || event instanceof VFileMoveEvent) {
            VirtualFile f = Objects.requireNonNull(event.getFile());
            f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
        } else if (event instanceof VFileDeleteEvent) {
            this.beforeFileDeletion((VFileDeleteEvent)event);
        }
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(1);
        }
        if (e.isRename()) {
            VirtualFile f = e.getFile();
            boolean isVersioned = this.myGateway.isVersioned(f);
            Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
            if (wasVersioned == null) {
                return;
            }
            f.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned.booleanValue() && !isVersioned) {
                return;
            }
            String oldName = (String)e.getOldValue();
            this.myVcs.renamed(this.myGateway.getPathOrUrl(f), oldName);
        } else if ("writable".equals(e.getPropertyName())) {
            if (!this.isVersioned(e.getFile())) {
                return;
            }
            VirtualFile f = e.getFile();
            if (!f.isDirectory()) {
                this.myVcs.readOnlyStatusChanged(this.myGateway.getPathOrUrl(f), (Boolean)e.getOldValue() == false);
            }
        }
    }

    private void fileMoved(@NotNull VFileMoveEvent e) {
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(2);
        }
        VirtualFile f = e.getFile();
        boolean isVersioned = this.myGateway.isVersioned(f);
        Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
        if (wasVersioned == null) {
            return;
        }
        f.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned.booleanValue() && !isVersioned) {
            return;
        }
        this.myVcs.moved(this.myGateway.getPathOrUrl(f), this.myGateway.getPathOrUrl(e.getOldParent()));
    }

    private void beforeFileDeletion(@NotNull VFileDeleteEvent e) {
        VirtualFile f;
        Entry entry2;
        if (e == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(3);
        }
        if ((entry2 = this.myGateway.createEntryForDeletion(f = e.getFile())) != null) {
            this.myVcs.deleted(this.myGateway.getPathOrUrl(f), entry2);
        }
    }

    private boolean isVersioned(VirtualFile f) {
        return this.myGateway.isVersioned(f);
    }

    private void handleBeforeEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(4);
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, true, () -> {
            for (VFileEvent event : events) {
                this.handleBeforeEvent(event);
            }
            for (BulkFileListener listener2 : this.myVfsEventListeners) {
                listener2.before(events);
            }
        });
    }

    private void handleAfterEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            LocalHistoryEventDispatcher.$$$reportNull$$$0(5);
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, false, () -> {
            for (VFileEvent event : events) {
                this.handleAfterEvent(event);
            }
            for (BulkFileListener listener2 : this.myVfsEventListeners) {
                listener2.after(events);
            }
        });
    }

    private void handleAfterEvent(VFileEvent event) {
        if (event instanceof VFileCreateEvent) {
            this.fileCreated(event.getFile());
        } else if (event instanceof VFileCopyEvent) {
            this.fileCreated(((VFileCopyEvent)event).findCreatedFile());
        } else if (event instanceof VFilePropertyChangeEvent) {
            this.propertyChanged((VFilePropertyChangeEvent)event);
        } else if (event instanceof VFileMoveEvent) {
            this.fileMoved((VFileMoveEvent)event);
        }
    }

    void addVirtualFileListener(BulkFileListener virtualFileListener, Disposable disposable) {
        this.myVfsEventListeners.add((Object)virtualFileListener, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeContentsChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBeforeEvents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAfterEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class LocalHistoryBulkFileListener
    implements BulkFileListener {
        LocalHistoryBulkFileListener() {
        }

        public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            LocalHistoryEventDispatcher dispatcher;
            if (events == null) {
                LocalHistoryBulkFileListener.$$$reportNull$$$0(0);
            }
            if ((dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl()) != null) {
                dispatcher.handleBeforeEvents(events);
            }
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            LocalHistoryEventDispatcher dispatcher;
            if (events == null) {
                LocalHistoryBulkFileListener.$$$reportNull$$$0(1);
            }
            if ((dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl()) != null) {
                dispatcher.handleAfterEvents(events);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "events";
            objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher$LocalHistoryBulkFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LocalHistoryCommandListener
    implements CommandListener {
        LocalHistoryCommandListener() {
        }

        public void commandStarted(@NotNull CommandEvent e) {
            LocalHistoryEventDispatcher dispatcher;
            if (e == null) {
                LocalHistoryCommandListener.$$$reportNull$$$0(0);
            }
            if ((dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl()) != null) {
                dispatcher.beginChangeSet();
            }
        }

        public void commandFinished(@NotNull CommandEvent e) {
            LocalHistoryEventDispatcher dispatcher;
            if (e == null) {
                LocalHistoryCommandListener.$$$reportNull$$$0(1);
            }
            if ((dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl()) != null) {
                dispatcher.endChangeSet(e.getCommandName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/history/integration/LocalHistoryEventDispatcher$LocalHistoryCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LocalHistoryFileManagerListener
    implements VirtualFileManagerListener {
        LocalHistoryFileManagerListener() {
        }

        public void beforeRefreshStart(boolean asynchronous) {
            LocalHistoryEventDispatcher dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
            if (dispatcher != null) {
                dispatcher.beginChangeSet();
            }
        }

        public void afterRefreshFinish(boolean asynchronous) {
            LocalHistoryEventDispatcher dispatcher = LocalHistoryImpl.getInstanceImpl().getEventDispatcher$intellij_platform_lvcs_impl();
            if (dispatcher != null) {
                dispatcher.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
            }
        }
    }
}

