/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryManager;
import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionNGramFeatures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "lazyManager", "Lkotlin/Lazy;", "Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "calcNGramFeatures", "Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "candidates", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcNextFileProbability", "", "file", "dispose", "", "getManagerIfInitialized", "onFileOpened", "onProjectClosed", "Companion", "EditorManagerListener", "ProjectClosureListener", "intellij.platform.ml.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryManagerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n*S KotlinDebug\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper\n*L\n35#1:76\n35#1:77,3\n*E\n"})
public final class FileHistoryManagerWrapper
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Lazy<FileHistoryManager> lazyManager;
    private static final int MAX_NGRAM_SEQUENCE = 3;

    public FileHistoryManagerWrapper(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"NextFilePrediction");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.lazyManager = LazyKt.lazy((Function0)((Function0)new Function0<FileHistoryManager>(this){
            final /* synthetic */ FileHistoryManagerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FileHistoryManager invoke() {
                return new FileHistoryManager(FileHistoryPersistence.INSTANCE.loadNGrams(FileHistoryManagerWrapper.access$getProject$p(this.this$0), 3));
            }
        }));
    }

    private final FileHistoryManager getManagerIfInitialized() {
        return this.lazyManager.isInitialized() ? (FileHistoryManager)this.lazyManager.getValue() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FilePredictionNGramFeatures calcNGramFeatures(@NotNull List<? extends VirtualFile> candidates) {
        FilePredictionNGramFeatures filePredictionNGramFeatures;
        FileHistoryManager managerIfInitialized;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        FileHistoryManager fileHistoryManager = managerIfInitialized = this.getManagerIfInitialized();
        if (fileHistoryManager != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = candidates;
            FileHistoryManager fileHistoryManager2 = fileHistoryManager;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                collection.add(string2);
            }
            filePredictionNGramFeatures = fileHistoryManager2.calcNGramFeatures((List)destination$iv$iv);
        } else {
            filePredictionNGramFeatures = null;
        }
        return filePredictionNGramFeatures;
    }

    public final double calcNextFileProbability(@NotNull VirtualFile file) {
        double d;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHistoryManager fileHistoryManager = this.getManagerIfInitialized();
        if (fileHistoryManager != null) {
            String string2 = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
            d = fileHistoryManager.calcNextFileProbability(string2);
        } else {
            d = 0.0;
        }
        return d;
    }

    private final void onFileOpened(VirtualFile file) {
        if (ProjectManagerImpl.Companion.isLight(this.project)) {
            return;
        }
        this.executor.submit(() -> FileHistoryManagerWrapper.onFileOpened$lambda$2(this, file));
    }

    private final void onProjectClosed(Project project2) {
        block0: {
            FileHistoryManager fileHistoryManager = this.getManagerIfInitialized();
            if (fileHistoryManager == null) break block0;
            fileHistoryManager.saveFileHistoryAsync(project2);
        }
    }

    public void dispose() {
        this.executor.shutdown();
    }

    private static final void onFileOpened$lambda$2$lambda$1(FileHistoryManagerWrapper this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        FileHistoryManager fileHistoryManager = (FileHistoryManager)this$0.lazyManager.getValue();
        String string2 = $file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
        fileHistoryManager.onFileOpened(string2);
    }

    private static final void onFileOpened$lambda$2(FileHistoryManagerWrapper this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this$0, () -> FileHistoryManagerWrapper.onFileOpened$lambda$2$lambda$1(this$0, $file));
    }

    public static final /* synthetic */ Project access$getProject$p(FileHistoryManagerWrapper $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion;", "", "()V", "MAX_NGRAM_SEQUENCE", "", "getInstance", "Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nFileHistoryManagerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,75:1\n30#2,3:76\n49#2:79\n*S KotlinDebug\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion\n*L\n22#1:76,3\n23#1:79\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileHistoryManagerWrapper getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<FileHistoryManagerWrapper> serviceClass$iv = FileHistoryManagerWrapper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (FileHistoryManagerWrapper)object;
        }

        @Nullable
        public final FileHistoryManagerWrapper getInstanceIfCreated(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
            boolean $i$f$serviceIfCreated = false;
            return (FileHistoryManagerWrapper)$this$serviceIfCreated$iv.getServiceIfCreated(FileHistoryManagerWrapper.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$EditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.ml.impl"})
    public static final class EditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getNewFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile newFile = virtualFile;
            Project project2 = event.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Companion.getInstance(project2).onFileOpened(newFile);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$ProjectClosureListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.impl"})
    public static final class ProjectClosureListener
    implements ProjectCloseListener {
        public void projectClosing(@NotNull Project project2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                FileHistoryManagerWrapper fileHistoryManagerWrapper = Companion.getInstanceIfCreated(project2);
                if (fileHistoryManagerWrapper == null) break block0;
                fileHistoryManagerWrapper.onProjectClosed(project2);
            }
        }
    }
}

