/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class CoverageDataAnnotationsManager
implements Disposable {
    private final Project myProject;
    private final Object myAnnotationsLock = new Object();
    private final Map<Editor, CoverageEditorAnnotator> myAnnotators = new HashMap<Editor, CoverageEditorAnnotator>();
    private final Map<Editor, Runnable> myRequests = new ConcurrentHashMap<Editor, Runnable>();
    private Alarm myRequestsAlarm;

    public CoverageDataAnnotationsManager(Project project2) {
        this.myProject = project2;
    }

    public static CoverageDataAnnotationsManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(0);
        }
        return (CoverageDataAnnotationsManager)project2.getService(CoverageDataAnnotationsManager.class);
    }

    public void clearAnnotations() {
        this.disposeAnnotators();
    }

    public void update() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        List openFiles = fileEditorManager.getOpenFilesWithRemotes();
        for (VirtualFile openFile : openFiles) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> openFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(openFile) : null);
            if (psiFile2 == null || !psiFile2.isPhysical()) {
                return;
            }
            for (FileEditor fileEditor : allEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                TextEditor textEditor = (TextEditor)fileEditor;
                Editor editor = textEditor.getEditor();
                this.callShowLater(editor, psiFile2);
            }
        }
    }

    @NotNull
    private synchronized Alarm getRequestsAlarm() {
        if (this.myRequestsAlarm == null) {
            this.myRequestsAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        }
        Alarm alarm2 = this.myRequestsAlarm;
        if (alarm2 == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(1);
        }
        return alarm2;
    }

    private void callShowLater(@NotNull Editor editor, PsiFile psiFile2) {
        if (editor == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(2);
        }
        Runnable task2 = () -> this.show(editor, psiFile2);
        this.myRequests.put(editor, task2);
        this.getRequestsAlarm().addRequest(task2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CoverageEditorAnnotator getOrCreateAnnotator(Editor editor, PsiFile file, CoverageEngine engine) {
        Object object = this.myAnnotationsLock;
        // MONITORENTER : object
        CoverageEditorAnnotator coverageEditorAnnotator = this.myAnnotators.computeIfAbsent(editor, x -> engine.createSrcFileAnnotator(file, editor));
        // MONITOREXIT : object
        if (coverageEditorAnnotator != null) return coverageEditorAnnotator;
        CoverageDataAnnotationsManager.$$$reportNull$$$0(3);
        return coverageEditorAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEditor(Editor editor) {
        CoverageEditorAnnotator annotator;
        this.myRequests.remove(editor);
        Object object = this.myAnnotationsLock;
        synchronized (object) {
            annotator = this.myAnnotators.remove(editor);
        }
        if (annotator != null) {
            Disposer.dispose((Disposable)annotator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAnnotators() {
        Object object = this.myAnnotationsLock;
        synchronized (object) {
            for (Map.Entry<Editor, CoverageEditorAnnotator> entry2 : this.myAnnotators.entrySet()) {
                this.myRequests.remove(entry2.getKey());
                Disposer.dispose((Disposable)entry2.getValue());
            }
            this.myAnnotators.clear();
        }
    }

    private void show(Editor editor, PsiFile psiFile2) {
        for (CoverageSuitesBundle bundle : CoverageDataManager.getInstance(this.myProject).activeSuites()) {
            CoverageEngine engine = bundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile2)) {
                return;
            }
            if (!engine.acceptedByFilters(psiFile2, bundle)) {
                return;
            }
            CoverageEditorAnnotator annotator = this.getOrCreateAnnotator(editor, psiFile2, engine);
            annotator.showCoverage(bundle);
        }
    }

    public void dispose() {
        this.disposeAnnotators();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataAnnotationsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataAnnotationsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestsAlarm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "callShowLater";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3 -> new IllegalStateException(string2);
        };
    }

    public static class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project2;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if ((project2 = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            if (CoverageDataManager.getInstance(project2).activeSuites().isEmpty()) {
                return;
            }
            CoverageDataAnnotationsManager manager = (CoverageDataAnnotationsManager)project2.getServiceIfCreated(CoverageDataAnnotationsManager.class);
            if (manager == null) {
                return;
            }
            PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()));
            if (psiFile2 == null || !psiFile2.isPhysical()) {
                return;
            }
            manager.callShowLater(editor, psiFile2);
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project2;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((project2 = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataAnnotationsManager manager = (CoverageDataAnnotationsManager)project2.getServiceIfCreated(CoverageDataAnnotationsManager.class);
            if (manager == null) {
                return;
            }
            Runnable request = manager.myRequests.remove(editor);
            if (request != null) {
                manager.getRequestsAlarm().cancelRequest(request);
            }
            manager.getRequestsAlarm().addRequest(() -> manager.clearEditor(editor), 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataAnnotationsManager$CoverageEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

