/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/completion/ml/VcsFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "Companion", "intellij.platform.vcs.impl"})
public final class VcsFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_CHANGES_TO_ANALYZE = 1000;
    @NotNull
    private static final Key<Integer> changesCountKey = new Key("VcsFeatureProvider.changesCount");

    @NotNull
    public String getName() {
        return "vcs";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map features;
        block5: {
            PsiElement psi;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            Integer changesCount = (Integer)contextFeatures.getUserData(changesCountKey);
            if (changesCount == null || changesCount > 1000) {
                return MapsKt.emptyMap();
            }
            features = new LinkedHashMap();
            Project project2 = location.getProject();
            PsiElement psiElement = psi = element.getPsiElement();
            Object psiFile2 = psiElement != null ? psiElement.getContainingFile() : null;
            PsiFile psiFile3 = psiFile2;
            if (psiFile3 == null || (psiFile3 = psiFile3.getViewProvider()) == null || (psiFile3 = psiFile3.getVirtualFile()) == null) break block5;
            PsiFile file = psiFile3;
            boolean bl = false;
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Change change = changeListManager2.getChange((VirtualFile)file);
            if (change != null) {
                Change change2 = change;
                boolean bl2 = false;
                features.put("file_state", MLFeatureValue.Companion.categorical((Enum)change2.getType()));
                if (change2.getType() == Change.Type.MODIFICATION && psi instanceof PsiNameIdentifierOwner) {
                    Document document2 = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(psiFile2);
                    TextRange range = ((PsiNameIdentifierOwner)psi).getTextRange();
                    if (document2 != null && range != null && range.getEndOffset() <= document2.getTextLength()) {
                        Intrinsics.checkNotNull((Object)project2);
                        LineStatusTracker<?> lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project2).getLineStatusTracker(document2);
                        if (lineStatusTracker != null && lineStatusTracker.isValid() && lineStatusTracker.isRangeModified(document2.getLineNumber(range.getStartOffset()), document2.getLineNumber(range.getEndOffset()))) {
                            features.put("declaration_is_changed", MLFeatureValue.Companion.binary(true));
                        }
                    }
                }
            }
        }
        return features;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/completion/ml/VcsFeatureProvider$Companion;", "", "()V", "MAX_CHANGES_TO_ANALYZE", "", "changesCountKey", "Lcom/intellij/openapi/util/Key;", "getChangesCountKey$intellij_platform_vcs_impl", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getChangesCountKey$intellij_platform_vcs_impl() {
            return changesCountKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

