/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.internal.impldep.org.apache.ivy.core.pack.ArchivePacking;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class ZipPacking
extends ArchivePacking {
    private static final String[] NAMES = new String[]{"zip", "jar", "war"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getUnpackedExtension(String ext) {
        if ((ext.endsWith("zip") || ext.endsWith("jar") || ext.endsWith("war")) && (ext = ext.substring(0, ext.length() - 3)).endsWith(".")) {
            ext = ext.substring(0, ext.length() - 1);
        }
        return ext;
    }

    @Override
    public void unpack(InputStream packed, File dest) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(packed);){
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String entryName = entry.getName();
                File f = FileUtil.resolveFile(dest, entryName);
                if (!FileUtil.isLeadingPath(dest, f, true)) {
                    Message.verbose("\t\tskipping " + entryName + " as its target " + f.getCanonicalPath() + " is outside of " + dest.getCanonicalPath() + ".");
                    continue;
                }
                Message.verbose("\t\texpanding " + entryName + " to " + f);
                File dirF = f.getParentFile();
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (entry.isDirectory()) {
                    f.mkdirs();
                } else {
                    this.writeFile(zip, f);
                }
                f.setLastModified(entry.getTime());
            }
        }
    }

    protected void writeFile(InputStream zip, File f) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            FileUtil.copy(zip, out, null, false);
        }
    }
}

