/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.event;

import java.util.ArrayList;
import org.gradle.internal.impldep.org.apache.ivy.core.event.IvyEvent;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.Matcher;
import org.gradle.internal.impldep.org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.internal.impldep.org.apache.ivy.util.StringUtils;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.AndFilter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.Filter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.NoFilter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.NotFilter;
import org.gradle.internal.impldep.org.apache.ivy.util.filter.OrFilter;

public class IvyEventFilter
implements Filter<IvyEvent> {
    private static final String NOT = "NOT ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";
    private PatternMatcher matcher;
    private Filter<IvyEvent> nameFilter;
    private Filter<IvyEvent> attFilter;

    public IvyEventFilter(String event, String filterExpression, PatternMatcher matcher) {
        PatternMatcher patternMatcher = this.matcher = matcher == null ? ExactPatternMatcher.INSTANCE : matcher;
        if (event == null) {
            this.nameFilter = NoFilter.instance();
        } else {
            final Matcher eventNameMatcher = this.matcher.getMatcher(event);
            this.nameFilter = new Filter<IvyEvent>(){

                @Override
                public boolean accept(IvyEvent e) {
                    return eventNameMatcher.matches(e.getName());
                }
            };
        }
        this.attFilter = StringUtils.isNullOrEmpty(filterExpression) ? NoFilter.instance() : this.parseExpression(filterExpression);
    }

    private Filter<IvyEvent> parseExpression(String filterExpression) {
        int index = (filterExpression = filterExpression.trim()).indexOf(AND);
        if (index == -1) {
            index = filterExpression.indexOf(OR);
            if (index == -1) {
                if (filterExpression.startsWith(NOT)) {
                    return new NotFilter<IvyEvent>(this.parseExpression(filterExpression.substring(NOT.length())));
                }
                index = filterExpression.indexOf("=");
                if (index == -1) {
                    throw new IllegalArgumentException("bad filter expression: " + filterExpression + ": no equal sign found");
                }
                final String attname = filterExpression.substring(0, index).trim();
                final ArrayList<Matcher> matchers = new ArrayList<Matcher>();
                for (String value : StringUtils.splitToArray(filterExpression.substring(index + 1))) {
                    matchers.add(this.matcher.getMatcher(value));
                }
                return new Filter<IvyEvent>(){

                    @Override
                    public boolean accept(IvyEvent e) {
                        String val = e.getAttributes().get(attname);
                        if (val == null) {
                            return false;
                        }
                        for (Matcher matcher : matchers) {
                            if (!matcher.matches(val)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new OrFilter<IvyEvent>(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + OR.length())));
        }
        return new AndFilter<IvyEvent>(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + AND.length())));
    }

    @Override
    public boolean accept(IvyEvent e) {
        return this.nameFilter.accept(e) && this.attFilter.accept(e);
    }
}

