/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform;

import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.XmlWriter;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleAndOperator;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeGreaterThanPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeLessThanPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecyclePredicateVisitor;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecyclePrefixPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;

class LifecyclePredicateVisitorImpl
implements LifecyclePredicateVisitor {
    private final XmlWriter xml;

    public LifecyclePredicateVisitorImpl(XmlWriter xml) {
        this.xml = xml;
    }

    @Override
    public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
        BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
    }

    @Override
    public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeTag(this.xml, lifecycleTagPredicate.getTag());
    }

    @Override
    public void visit(LifecycleObjectSizeGreaterThanPredicate lifecycleObjectSizeGreaterThanPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeObjectSizeGreaterThan(this.xml, lifecycleObjectSizeGreaterThanPredicate.getObjectSizeGreaterThan());
    }

    @Override
    public void visit(LifecycleObjectSizeLessThanPredicate lifecycleObjectSizeLessThanPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeObjectSizeLessThan(this.xml, lifecycleObjectSizeLessThanPredicate.getObjectSizeLessThan());
    }

    @Override
    public void visit(LifecycleAndOperator lifecycleAndOperator) {
        this.xml.start("And");
        for (LifecycleFilterPredicate predicate : lifecycleAndOperator.getOperands()) {
            predicate.accept(this);
        }
        this.xml.end();
    }
}

