/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "Lcom/intellij/ui/components/Magnificator;", "()V", "pressed", "Ljava/awt/Point;", "getPressed", "()Ljava/awt/Point;", "setPressed", "(Ljava/awt/Point;)V", "magnify", "scale", "", "at", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "event", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "Companion", "intellij.profiler.common"})
public class ScrollableMouseAdapter
extends MouseAdapter
implements Magnificator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Point pressed;
    public static final double ZOOM_SCALE_FACTOR = 1.2;

    @Nullable
    protected final Point getPressed() {
        return this.pressed;
    }

    protected final void setPressed(@Nullable Point point) {
        this.pressed = point;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getButton() == 1) {
            this.pressed = event.getPoint();
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getSource();
        JViewport vp = ComponentUtil.getViewport((Component)(object instanceof JComponent ? (JComponent)object : null));
        if (this.pressed != null && vp != null) {
            Point position = vp.getViewPosition();
            int n = event.getX();
            Point point = this.pressed;
            Intrinsics.checkNotNull((Object)point);
            int xOffset = n - point.x;
            int n2 = event.getY();
            Point point2 = this.pressed;
            Intrinsics.checkNotNull((Object)point2);
            int yOffset = n2 - point2.y;
            int newX = Math.max(Math.min(position.x - xOffset, vp.getView().getWidth() - vp.getWidth()), 0);
            int newY = Math.max(Math.min(position.y - yOffset, vp.getView().getHeight() - vp.getHeight()), 0);
            vp.setViewPosition(new Point(newX, newY));
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.pressed = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ProfilerUIUtilsKt.isZoomKeyDown(e)) {
            ZoomableViewport zoomable;
            Point p = e.getPoint();
            int sign = e.getWheelRotation();
            ZoomableViewport zoomableViewport = zoomable = (ZoomableViewport)ComponentUtil.getParentOfType(ZoomableViewport.class, (Component)e.getComponent());
            ZoomableViewport zoomableViewport2 = zoomableViewport;
            if (zoomableViewport == null) return;
            Magnificator magnificator = zoomableViewport2.getMagnificator();
            zoomableViewport2 = magnificator;
            if (magnificator == null) return;
            ZoomableViewport it = zoomableViewport2;
            boolean bl = false;
            if (sign < 0) {
                v3 = it.magnify(1.2, p);
                return;
            } else {
                if (sign <= 0) return;
                v3 = it.magnify(0.8333333333333334, p);
            }
            return;
        } else {
            e.getComponent().getParent().dispatchEvent(e);
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@Nullable MouseEvent e) {
    }

    @NotNull
    public Point magnify(double scale, @NotNull Point at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return at;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter$Companion;", "", "()V", "ZOOM_SCALE_FACTOR", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

