/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.grouping;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nJ\u001e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H&J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ui/grouping/FlameGraphNodesGrouper;", "", "groupWithRootNode", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "root", "Lcom/intellij/profiler/model/CallTreeNode;", "isApplicable", "", "node", "Companion", "intellij.profiler.common"})
public interface FlameGraphNodesGrouper {
    @NotNull
    public static final Companion Companion = com.intellij.profiler.ui.grouping.FlameGraphNodesGrouper$Companion.$$INSTANCE;

    default public boolean isApplicable(@NotNull CallTreeNode<? extends BaseCallStackElement> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        return false;
    }

    @Nullable
    public FoldingNodesGroup<BaseCallStackElement> groupWithRootNode(@NotNull CallTreeNode<? extends BaseCallStackElement> var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000b\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fJ \u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u000bH\u0002J(\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/grouping/FlameGraphNodesGrouper$Companion;", "", "()V", "EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/profiler/ui/grouping/FlameGraphNodesGrouper;", "getEP$intellij_profiler_common", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "groupWithRootNode", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "root", "Lcom/intellij/profiler/model/CallTreeNode;", "validateGroup", "", "group", "validationFailed", "", "message", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nFlameGraphNodesGrouper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameGraphNodesGrouper.kt\ncom/intellij/profiler/ui/grouping/FlameGraphNodesGrouper$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n10#2:69\n*S KotlinDebug\n*F\n+ 1 FlameGraphNodesGrouper.kt\ncom/intellij/profiler/ui/grouping/FlameGraphNodesGrouper$Companion\n*L\n37#1:69\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<FlameGraphNodesGrouper> EP;
        @NotNull
        private static final Logger LOG;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<FlameGraphNodesGrouper> getEP$intellij_profiler_common() {
            return EP;
        }

        @Nullable
        public final <Call extends BaseCallStackElement> FoldingNodesGroup<Call> groupWithRootNode(@NotNull CallTreeNode<? extends Call> root) {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            for (FlameGraphNodesGrouper grouper : (FlameGraphNodesGrouper[])EP.getExtensions()) {
                FoldingNodesGroup<BaseCallStackElement> group2;
                if (!grouper.isApplicable(root) || (group2 = grouper.groupWithRootNode(root)) == null || !this.validateGroup(group2)) continue;
                return group2;
            }
            return null;
        }

        private final <Call extends BaseCallStackElement> boolean validateGroup(FoldingNodesGroup<Call> group2) {
            CallWithValue groupStartData = (CallWithValue)group2.getGroupStart().getData();
            if (groupStartData == null) {
                this.validationFailed(group2, "Root node cannot be a start of a group");
                return false;
            }
            long groupStartValue = groupStartData.getValue();
            long totalChildrenValue = 0L;
            List<CallTreeNode<Call>> endNodes = group2.getGroupEnd();
            for (CallTreeNode<Call> endNode : endNodes) {
                Object Data = endNode.getData();
                Intrinsics.checkNotNull(Data);
                long value = ((CallWithValue)Data).getValue();
                totalChildrenValue += value;
            }
            if (groupStartValue < totalChildrenValue) {
                this.validationFailed(group2, StringsKt.trimIndent((String)("\n          Sum of children values is greater than a group start value:\n          children value:    " + totalChildrenValue + "\n          group start value: " + groupStartValue + "\n        ")));
                return false;
            }
            return true;
        }

        private final <Call extends BaseCallStackElement> void validationFailed(FoldingNodesGroup<Call> group2, String message2) {
            Object object = (CallWithValue)group2.getGroupStart().getData();
            if (object == null || (object = (BaseCallStackElement)object.getCall()) == null) {
                object = "<root>";
            }
            LOG.warn("Cannot make a group starting with node \"" + object + "\": " + message2);
        }

        static {
            $$INSTANCE = new Companion();
            EP = ExtensionPointName.Companion.create("com.intellij.profiler.flameGraphNodesGrouper");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FlameGraphNodesGrouper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }
}

