/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.TerminalCaretModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002-.B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u001c\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\b\u0010&\u001a\u00020\u001bH\u0007J$\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u001a\u0010,\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel$TerminalSelectionListener;", "caretModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "caretColor", "Ljava/awt/Color;", "getCaretColor", "()Ljava/awt/Color;", "caretHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "caretUpdater", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter$BlinkingCaretUpdater;", "isBlockActive", "", "isFocused", "calculateCaretHeight", "", "caretBlinkingChanged", "", "isBlinking", "caretPositionChanged", "oldPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "newPosition", "focusGained", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "installCaretHighlighter", "removeHighlighter", "repaint", "selectionChanged", "oldSelection", "", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "newSelection", "updateCaretHighlighter", "BlinkingCaretUpdater", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCaretPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCaretPainter.kt\norg/jetbrains/plugins/terminal/exp/TerminalCaretPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
public final class TerminalCaretPainter
implements TerminalCaretModel.CaretListener,
FocusChangeListener,
TerminalSelectionModel.TerminalSelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalCaretModel caretModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final EditorEx editor;
    @Nullable
    private RangeHighlighter caretHighlighter;
    @Nullable
    private BlinkingCaretUpdater caretUpdater;
    private boolean isFocused;
    private boolean isBlockActive;
    @NotNull
    private static final Color CARET_LIGHT;
    @NotNull
    private static final Color CARET_DARK;

    public TerminalCaretPainter(@NotNull TerminalCaretModel caretModel, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSelectionModel selectionModel, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)caretModel, (String)"caretModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.caretModel = caretModel;
        this.outputModel = outputModel;
        this.editor = editor;
        this.isBlockActive = true;
        TerminalCaretModel.addListener$default(this.caretModel, this, null, 2, null);
        TerminalSelectionModel.addListener$default(selectionModel, this, null, 2, null);
        this.editor.addFocusListener((FocusChangeListener)this, (Disposable)this.caretModel);
    }

    private final Color getCaretColor() {
        Color color = this.editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        if (color == null) {
            color = (Color)new JBColor(CARET_DARK, CARET_LIGHT);
        }
        return color;
    }

    @RequiresEdt
    public final void repaint() {
        this.updateCaretHighlighter(this.caretModel.getCaretPosition(), this.caretModel.isBlinking());
    }

    @Override
    public void caretPositionChanged(@Nullable LogicalPosition oldPosition, @Nullable LogicalPosition newPosition) {
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, newPosition){
            final /* synthetic */ TerminalCaretPainter this$0;
            final /* synthetic */ LogicalPosition $newPosition;
            {
                this.this$0 = $receiver;
                this.$newPosition = $newPosition;
                super(0);
            }

            public final void invoke() {
                if (!TerminalCaretPainter.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalCaretPainter.access$updateCaretHighlighter(this.this$0, this.$newPosition, TerminalCaretPainter.access$getCaretModel$p(this.this$0).isBlinking());
                }
            }
        }), (int)1, null);
    }

    @Override
    public void caretBlinkingChanged(boolean isBlinking) {
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, isBlinking){
            final /* synthetic */ TerminalCaretPainter this$0;
            final /* synthetic */ boolean $isBlinking;
            {
                this.this$0 = $receiver;
                this.$isBlinking = $isBlinking;
                super(0);
            }

            public final void invoke() {
                if (!TerminalCaretPainter.access$getEditor$p(this.this$0).isDisposed()) {
                    TerminalCaretPainter.access$updateCaretHighlighter(this.this$0, TerminalCaretPainter.access$getCaretModel$p(this.this$0).getCaretPosition(), this.$isBlinking);
                }
            }
        }), (int)1, null);
    }

    public void focusGained(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.isFocused = true;
        this.repaint();
    }

    public void focusLost(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.isFocused = false;
        this.updateCaretHighlighter(null, this.caretModel.isBlinking());
    }

    @Override
    public void selectionChanged(@NotNull List<CommandBlock> oldSelection, @NotNull List<CommandBlock> newSelection) {
        Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
        Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
        boolean bl = this.isBlockActive = newSelection.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.singleOrNull(newSelection), (Object)this.outputModel.getLastBlock());
        if (this.isBlockActive) {
            this.repaint();
        } else {
            this.updateCaretHighlighter(null, this.caretModel.isBlinking());
        }
    }

    private final void updateCaretHighlighter(LogicalPosition newPosition, boolean isBlinking) {
        this.removeHighlighter();
        BlinkingCaretUpdater blinkingCaretUpdater = this.caretUpdater;
        if (blinkingCaretUpdater != null) {
            BlinkingCaretUpdater it = blinkingCaretUpdater;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.caretUpdater = null;
        if (newPosition != null && this.isFocused && this.isBlockActive) {
            this.installCaretHighlighter(newPosition);
            if (isBlinking) {
                this.caretUpdater = new BlinkingCaretUpdater(newPosition);
                Disposable disposable = this.caretModel;
                BlinkingCaretUpdater blinkingCaretUpdater2 = this.caretUpdater;
                Intrinsics.checkNotNull((Object)blinkingCaretUpdater2);
                Disposer.register((Disposable)disposable, (Disposable)blinkingCaretUpdater2);
            }
        }
    }

    private final void installCaretHighlighter(LogicalPosition newPosition) {
        int newOffset = this.editor.logicalPositionToOffset(newPosition);
        Color caretForeground = ColorUtil.isDark((Color)this.getCaretColor()) ? CARET_LIGHT : CARET_DARK;
        TextAttributes attributes = new TextAttributes(caretForeground, null, null, null, 0);
        int endOffset = newOffset + 1 < this.editor.getDocument().getTextLength() ? newOffset + 1 : newOffset;
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(newOffset, endOffset, 6000, attributes, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setCustomRenderer((arg_0, arg_1, arg_2) -> TerminalCaretPainter.installCaretHighlighter$lambda$1(highlighter, this, arg_0, arg_1, arg_2));
        this.caretHighlighter = highlighter;
    }

    private final void removeHighlighter() {
        RangeHighlighter rangeHighlighter = this.caretHighlighter;
        if (rangeHighlighter != null) {
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
        }
        this.caretHighlighter = null;
    }

    private final int calculateCaretHeight() {
        double rawCaretInset = (double)this.editor.getLineHeight() * 0.2;
        int caretInsets = (int)Math.floor(rawCaretInset) % 2 == 0 ? (int)Math.floor(rawCaretInset) : (int)Math.ceil(rawCaretInset);
        return this.editor.getLineHeight() - caretInsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void installCaretHighlighter$lambda$1(RangeHighlighter $highlighter, TerminalCaretPainter this$0, Editor editor, RangeHighlighter rangeHighlighter, Graphics g) {
        Intrinsics.checkNotNullParameter((Object)$highlighter, (String)"$highlighter");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"<anonymous parameter 1>");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int offset = $highlighter.getStartOffset();
        Point2D point2D = this$0.editor.offsetToPoint2D(offset);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"offsetToPoint2D(...)");
        Point2D point = point2D;
        int caretHeight = this$0.calculateCaretHeight();
        int caretInset = (this$0.editor.getLineHeight() - caretHeight) / 2;
        double d = point.getX();
        double d2 = point.getY() + (double)caretInset;
        EditorEx editorEx = this$0.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        Rectangle2D.Double rect = new Rectangle2D.Double(d, d2, ((EditorImpl)editorEx).getCharHeight(), caretHeight);
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Color oldColor = ((Graphics2D)g).getColor();
        try {
            ((Graphics2D)g).setColor(this$0.getCaretColor());
            ((Graphics2D)g).fill(rect);
        }
        finally {
            ((Graphics2D)g).setColor(oldColor);
        }
    }

    public static final /* synthetic */ void access$updateCaretHighlighter(TerminalCaretPainter $this, LogicalPosition newPosition, boolean isBlinking) {
        $this.updateCaretHighlighter(newPosition, isBlinking);
    }

    public static final /* synthetic */ TerminalCaretModel access$getCaretModel$p(TerminalCaretPainter $this) {
        return $this.caretModel;
    }

    static {
        Gray gray = Gray._255;
        Intrinsics.checkNotNullExpressionValue((Object)gray, (String)"_255");
        CARET_LIGHT = (Color)gray;
        Gray gray2 = Gray._0;
        Intrinsics.checkNotNullExpressionValue((Object)gray2, (String)"_0");
        CARET_DARK = (Color)gray2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter$BlinkingCaretUpdater;", "Lcom/intellij/openapi/Disposable;", "position", "Lcom/intellij/openapi/editor/LogicalPosition;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;Lcom/intellij/openapi/editor/LogicalPosition;)V", "paintCaret", "", "updateFuture", "Ljava/util/concurrent/ScheduledFuture;", "dispose", "", "update", "intellij.terminal"})
    private final class BlinkingCaretUpdater
    implements Disposable {
        @NotNull
        private final LogicalPosition position;
        @NotNull
        private final ScheduledFuture<?> updateFuture;
        private boolean paintCaret;

        public BlinkingCaretUpdater(LogicalPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.position = position;
            long period = TerminalCaretPainter.this.editor.getSettings().getCaretBlinkPeriod();
            ScheduledFuture<?> scheduledFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::update, period, period, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
            this.updateFuture = scheduledFuture;
        }

        private final void update() {
            if (!TerminalCaretPainter.this.editor.isDisposed()) {
                TerminalCaretPainter.this.removeHighlighter();
                if (this.paintCaret) {
                    TerminalCaretPainter.this.installCaretHighlighter(this.position);
                }
                this.paintCaret = !this.paintCaret;
            }
        }

        public void dispose() {
            this.updateFuture.cancel(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter$Companion;", "", "()V", "CARET_DARK", "Ljava/awt/Color;", "CARET_LIGHT", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

