/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.util;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.intellij.pom.java.LanguageLevel;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    @Nullable
    public static LanguageLevel parseFromGradleString(@NotNull String gradleString) {
        if (gradleString == null) {
            LanguageLevelUtil.$$$reportNull$$$0(0);
        }
        String digitalVersion = gradleString.startsWith("JavaVersion.VERSION_") ? gradleString.substring("JavaVersion.VERSION_".length()).replace('_', '.') : (gradleString.startsWith("VERSION_") ? gradleString.substring("VERSION_".length()).replace('_', '.') : (gradleString.startsWith("'") || gradleString.startsWith("\"") ? gradleString.substring(1, gradleString.length() - 1) : gradleString));
        return LanguageLevel.parse((String)digitalVersion);
    }

    @NotNull
    public static Object convertToGradleString(@NotNull LanguageLevel languageLevel, @Nullable String sampleGradleString) {
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(1);
        }
        String underscoreVersion = languageLevel.name().substring("JDK_".length());
        String dotVersion = underscoreVersion.replace('_', '.');
        if (sampleGradleString != null) {
            if (sampleGradleString.startsWith("JavaVersion.VERSION_")) {
                return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("VERSION_")) {
                return new RawText("VERSION_" + underscoreVersion, "VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("'")) {
                String string = "'" + dotVersion + "'";
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (sampleGradleString.startsWith("\"")) {
                String string = "\"" + dotVersion + "\"";
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
            try {
                return new BigDecimal(dotVersion);
            }
            catch (NumberFormatException e) {
                String string = dotVersion;
                if (string == null) {
                    LanguageLevelUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
    }

    @Nullable
    public static String getStringToParse(ResolvedPropertyModel model) {
        return switch (model.getValueType()) {
            case GradlePropertyModel.ValueType.BIG_DECIMAL, GradlePropertyModel.ValueType.INTEGER, GradlePropertyModel.ValueType.REFERENCE, GradlePropertyModel.ValueType.CUSTOM -> model.toString();
            case GradlePropertyModel.ValueType.STRING -> "'" + model.toString() + "'";
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/api/util/LanguageLevelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/api/util/LanguageLevelUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToGradleString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFromGradleString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToGradleString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

