/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

public class DaemonState
implements Serializable {
    private final Long myPid;
    private final byte[] myToken;
    private final String myVersion;
    private final String myStatus;
    private final String myReason;
    private final long myTimestamp;
    private final String myDaemonExpirationStatus;
    private final List<String> myDaemonOpts;
    private final File myJavaHome;
    private final Integer myIdleTimeout;
    private final File myRegistryDir;

    public DaemonState(Long pid, byte[] token, String version, String status, String reason, long timestamp, String daemonExpirationStatus, List<String> daemonOpts, File javaHome, Integer idleTimeout, File registryDir) {
        this.myPid = pid;
        this.myToken = token;
        this.myVersion = version;
        this.myStatus = status;
        this.myReason = reason;
        this.myTimestamp = timestamp;
        this.myDaemonExpirationStatus = daemonExpirationStatus;
        this.myDaemonOpts = daemonOpts;
        this.myJavaHome = javaHome;
        this.myIdleTimeout = idleTimeout;
        this.myRegistryDir = registryDir;
    }

    public Long getPid() {
        return this.myPid;
    }

    public byte[] getToken() {
        return this.myToken;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getStatus() {
        return this.myStatus;
    }

    public String getReason() {
        return this.myReason;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public String getDaemonExpirationStatus() {
        return this.myDaemonExpirationStatus;
    }

    public List<String> getDaemonOpts() {
        return this.myDaemonOpts;
    }

    public File getJavaHome() {
        return this.myJavaHome;
    }

    public Integer getIdleTimeout() {
        return this.myIdleTimeout;
    }

    public File getRegistryDir() {
        return this.myRegistryDir;
    }

    public String getDescription() {
        StringBuilder info = new StringBuilder();
        info.append(this.myPid).append(" ").append(DateFormat.getDateTimeInstance(3, 3).format(new Date(this.myTimestamp))).append(" ").append(this.myStatus).append(" ");
        if (this.myVersion != null && !this.myVersion.isEmpty()) {
            info.append("Gradle version: ").append(this.myVersion);
        }
        if (this.myDaemonExpirationStatus != null && !this.myDaemonExpirationStatus.isEmpty()) {
            info.append("\nExpiration status: ").append(this.myDaemonExpirationStatus);
        }
        if (this.myReason != null && !this.myReason.isEmpty()) {
            info.append("\nStop reason: ").append(this.myReason);
        }
        if (this.myRegistryDir != null) {
            info.append("\nDaemons dir: ").append(this.myRegistryDir);
        }
        if (this.myJavaHome != null) {
            info.append("\nJava home: ").append(this.myJavaHome.getPath());
        }
        if (this.myDaemonOpts != null && !this.myDaemonOpts.isEmpty()) {
            info.append("\nDaemon options: ").append(this.myDaemonOpts);
        }
        if (this.myIdleTimeout != null) {
            info.append("\nIdle timeout: ").append(this.myIdleTimeout);
        }
        return info.toString();
    }
}

