/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineProgressReporterElement;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.ide.impl.ProjectOpenKeyProvider;
import com.intellij.ide.warmup.WarmupConfigurator;
import com.intellij.ide.warmup.WarmupStatus;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleWarmupConfigurator;
import org.jetbrains.plugins.gradle.GradleWarmupConfiguratorKt;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationListener;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationManager;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsTaskId;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleImportHint;
import org.jetbrains.plugins.gradle.settings.GradleImportHintService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.startup.GradleProjectSettingsUpdater;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/GradleWarmupConfigurator;", "Lcom/intellij/ide/warmup/WarmupConfigurator;", "()V", "configuratorPresentableName", "", "getConfiguratorPresentableName", "()Ljava/lang/String;", "importProjects", "", "project", "Lcom/intellij/openapi/project/Project;", "linkGradleHintProjects", "", "basePath", "linkProjects", "linkRootProject", "prepareEnvironment", "projectPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runWarmup", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ImportErrorListener", "LoggingNotificationListener", "StateExternalAnnotationNotificationListener", "StateNotificationListener", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nGradleWarmupConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleWarmupConfigurator.kt\norg/jetbrains/plugins/gradle/GradleWarmupConfigurator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n43#2,3:297\n1#3:300\n1855#4,2:301\n*S KotlinDebug\n*F\n+ 1 GradleWarmupConfigurator.kt\norg/jetbrains/plugins/gradle/GradleWarmupConfigurator\n*L\n66#1:297,3\n117#1:301,2\n*E\n"})
public final class GradleWarmupConfigurator
implements WarmupConfigurator {
    @NotNull
    private final String configuratorPresentableName;

    public GradleWarmupConfigurator() {
        this.configuratorPresentableName = "gradle";
    }

    @NotNull
    public String getConfiguratorPresentableName() {
        return this.configuratorPresentableName;
    }

    @Nullable
    public Object prepareEnvironment(@NotNull Path projectPath, @NotNull Continuation<? super Unit> $completion) {
        CommandLineProgressReporterElement reporter;
        CommandLineProgressReporterElement commandLineProgressReporterElement = reporter = (CommandLineProgressReporterElement)$completion.getContext().get((CoroutineContext.Key)CommandLineProgressReporterElement.Key);
        GradleWarmupConfiguratorKt.prepareGradleConfiguratorEnvironment((CommandLineInspectionProgressReporter)(commandLineProgressReporterElement != null ? commandLineProgressReporterElement.getReporter() : null));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public Object runWarmup(@NotNull Project var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof runWarmup.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ GradleWarmupConfigurator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runWarmup(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = project.getBasePath();
                if (v0 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                basePath = v0;
                $i$f$service = false;
                serviceClass$iv = EnvironmentService.class;
                var7_10 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var7_10 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                service = (EnvironmentService)var7_10;
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = basePath;
                $continuation.label = 1;
                v1 = service.getEnvironmentValue(ProjectOpenKeyProvider.Keys.INSTANCE.getPROJECT_OPEN_PROCESSOR(), "Gradle", (Continuation)$continuation);
                if (v1 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                basePath = (String)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (GradleWarmupConfigurator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(projectSelectionKey = (String)v1), (Object)"Gradle")) {
                    return Boxing.boxBoolean((boolean)false);
                }
                state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
                if (state.getSkip()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                if (GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty()) {
                    this.linkProjects(basePath, project);
                }
                progressManager = ExternalSystemProgressNotificationManager.getInstance();
                scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)$continuation.getContext());
                notificationListener = new StateNotificationListener(project, scope);
                errorListener = new ImportErrorListener(project, scope);
                externalAnnotationsNotificationManager = ExternalAnnotationsProgressNotificationManager.Companion.getInstance();
                externalAnnotationsProgressListener = new StateExternalAnnotationNotificationListener();
                externalAnnotationsNotificationManager.addNotificationListener(externalAnnotationsProgressListener);
                progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)notificationListener);
                progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)errorListener);
                $continuation.L$0 = progressManager;
                $continuation.L$1 = notificationListener;
                $continuation.L$2 = errorListener;
                $continuation.L$3 = externalAnnotationsNotificationManager;
                $continuation.L$4 = externalAnnotationsProgressListener;
                $continuation.label = 2;
                v2 = CoroutinesKt.blockingContextScope((Function0)((Function0)new Function0<Unit>(this, project){
                    final /* synthetic */ GradleWarmupConfigurator this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(0);
                    }

                    public final void invoke() {
                        GradleWarmupConfigurator.access$importProjects(this.this$0, this.$project);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var18_5) goto lbl66
lbl65:
                // 1 sources

                return var18_5;
lbl66:
                // 1 sources

                ** GOTO lbl77
            }
            case 2: {
                externalAnnotationsProgressListener = (StateExternalAnnotationNotificationListener)$continuation.L$4;
                externalAnnotationsNotificationManager = (ExternalAnnotationsProgressNotificationManager)$continuation.L$3;
                errorListener = (ImportErrorListener)$continuation.L$2;
                notificationListener = (StateNotificationListener)$continuation.L$1;
                progressManager = (ExternalSystemProgressNotificationManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl77:
                    // 2 sources

                    v3 = errorListener.getError();
                    if (v3 != null) {
                        it = v3;
                        $i$a$-let-GradleWarmupConfigurator$runWarmup$3 = false;
                        throw it;
                    }
                }
                catch (Throwable var13_19) {
                    throw var13_19;
                }
                finally {
                    progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)notificationListener);
                    progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)errorListener);
                    externalAnnotationsNotificationManager.removeNotificationListener(externalAnnotationsProgressListener);
                }
                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void linkProjects(String basePath, Project project) {
        if (this.linkGradleHintProjects(basePath, project)) {
            return;
        }
        this.linkRootProject(basePath, project);
    }

    private final void importProjects(Project project) {
        Collection collection = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Collection linkedProjectsSettings = collection;
        if (linkedProjectsSettings.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = linkedProjectsSettings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)it));
            GradleProjectSettingsUpdater.Util.INSTANCE.updateGradleJvm(project, it).get(10L, TimeUnit.MINUTES);
        }
        AutoImportProjectTracker.Companion.onceIgnoreDisableAutoReloadRegistry();
        AutoImportProjectTracker.Companion.getInstance(project).scheduleProjectRefresh();
    }

    private final boolean linkRootProject(String basePath, Project project) {
        String gradleGroovyDslFile = basePath + "/build.gradle";
        String kotlinDslGradleFile = basePath + "/build.gradle.kts";
        String[] stringArray = new String[]{gradleGroovyDslFile, kotlinDslGradleFile};
        if (FileUtil.findFirstThatExist((String[])stringArray) == null) {
            return false;
        }
        GradleWarmupConfiguratorKt.access$getLOG$p().info("Link gradle project from root directory");
        Path path = Paths.get(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path, project);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
        return true;
    }

    private final boolean linkGradleHintProjects(String basePath, Project project) {
        GradleImportHint state = (GradleImportHint)GradleImportHintService.Companion.getInstance(project).getState();
        if (!((Collection)state.getProjectsToImport()).isEmpty()) {
            for (String projectPath : state.getProjectsToImport()) {
                Path buildFile = new File(basePath).toPath().resolve(projectPath);
                if (buildFile.toFile().exists()) {
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Link gradle project from intellij.yaml: " + projectPath);
                    Path path = buildFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                    GradleProjectSettings settings2 = GradleProjectImportUtil.createLinkSettings(path, project);
                    ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)settings2);
                    continue;
                }
                GradleWarmupConfiguratorKt.access$getLOG$p().error("File for linking gradle project doesn't exist: " + buildFile.toAbsolutePath());
                return false;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$importProjects(GradleWarmupConfigurator $this, Project project) {
        $this.importProjects(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/GradleWarmupConfigurator$ImportErrorListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "_error", "Ljava/util/concurrent/atomic/AtomicReference;", "", "error", "getError", "()Ljava/lang/Throwable;", "onFailure", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "storeError", "t", "intellij.gradle.common"})
    public static final class ImportErrorListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final AtomicReference<Throwable> _error;

        public ImportErrorListener(@NotNull Project project, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.project = project;
            this.scope = scope;
            this._error = new AtomicReference();
        }

        @Nullable
        public final Throwable getError() {
            return this._error.get();
        }

        private final void storeError(Throwable t) {
            block0: {
                Throwable throwable = this._error.compareAndExchange(null, t);
                if (throwable == null) break block0;
                ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)t);
            }
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.scope);
            Topic topic = ProjectDataImportListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, (Object)new ProjectDataImportListener(this){
                final /* synthetic */ ImportErrorListener this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImportFailed(@Nullable String projectPath, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ImportErrorListener.access$storeError(this.this$0, t);
                }
            });
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            this.storeError(e);
        }

        public static final /* synthetic */ void access$storeError(ImportErrorListener $this, Throwable t) {
            $this.storeError(t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/GradleWarmupConfigurator$LoggingNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "logger", "Lcom/intellij/ide/CommandLineInspectionProgressReporter;", "(Lcom/intellij/ide/CommandLineInspectionProgressReporter;)V", "logPath", "Ljava/nio/file/Path;", "getLogger", "()Lcom/intellij/ide/CommandLineInspectionProgressReporter;", "onTaskOutput", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "text", "", "stdOut", "", "processMessage", "gradleText", "intellij.gradle.common"})
    public static final class LoggingNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @Nullable
        private final CommandLineInspectionProgressReporter logger;
        @NotNull
        private final Path logPath;

        public LoggingNotificationListener(@Nullable CommandLineInspectionProgressReporter logger) {
            Path path;
            LoggingNotificationListener loggingNotificationListener;
            this.logger = logger;
            LoggingNotificationListener loggingNotificationListener2 = this;
            try {
                loggingNotificationListener = loggingNotificationListener2;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createFile(PathKt.createParentDirectories((Path)GradleWarmupConfiguratorKt.access$getGradleLogWriterPath$p()), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
                path = path2;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                loggingNotificationListener = loggingNotificationListener2;
                path = GradleWarmupConfiguratorKt.access$getGradleLogWriterPath$p();
            }
            loggingNotificationListener.logPath = path;
        }

        @Nullable
        public final CommandLineInspectionProgressReporter getLogger() {
            return this.logger;
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                String gradleText = (stdOut ? "" : "STDERR: ") + text;
                PathsKt.appendText$default((Path)this.logPath, (CharSequence)gradleText, null, (int)2, null);
                String croppedMessage = this.processMessage(gradleText);
                if (croppedMessage == null) break block1;
                CommandLineInspectionProgressReporter commandLineInspectionProgressReporter = this.logger;
                if (commandLineInspectionProgressReporter != null) {
                    commandLineInspectionProgressReporter.reportMessage(1, croppedMessage);
                }
            }
        }

        private final String processMessage(String gradleText) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            if (!Intrinsics.areEqual((Object)WarmupStatus.Companion.currentStatus(application), (Object)WarmupStatus.InProgress.INSTANCE)) {
                return gradleText;
            }
            char[] cArray = new char[]{'\r'};
            String string2 = StringsKt.trimStart((String)gradleText, (char[])cArray);
            cArray = new char[]{'\n'};
            String cropped = StringsKt.trimEnd((String)string2, (char[])cArray);
            if (StringsKt.startsWith$default((String)cropped, (String)"Download", (boolean)false, (int)2, null)) {
                if (StringsKt.contains$default((CharSequence)cropped, (CharSequence)" took ", (boolean)false, (int)2, null)) {
                    return cropped;
                }
                return null;
            }
            return cropped;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/GradleWarmupConfigurator$StateExternalAnnotationNotificationListener;", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsProgressNotificationListener;", "()V", "onFinishResolve", "", "id", "Lorg/jetbrains/plugins/gradle/service/notification/ExternalAnnotationsTaskId;", "onStartResolve", "intellij.gradle.common"})
    public static final class StateExternalAnnotationNotificationListener
    implements ExternalAnnotationsProgressNotificationListener {
        @Override
        public void onStartResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle resolving external annotations started " + id.getProjectId());
        }

        @Override
        public void onFinishResolve(@NotNull ExternalAnnotationsTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle resolving external annotations completed " + id.getProjectId());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/GradleWarmupConfigurator$StateNotificationListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListenerAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "onCancel", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "workingDir", "", "onSuccess", "intellij.gradle.common"})
    public static final class StateNotificationListener
    extends ExternalSystemTaskNotificationListenerAdapter {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope scope;

        public StateNotificationListener(@NotNull Project project, @NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.project = project;
            this.scope = scope;
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle resolve stage finished with success: " + id.getIdeProjectId());
            SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().connect(this.scope);
            Topic topic = ProjectDataImportListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, (Object)new ProjectDataImportListener(id){
                final /* synthetic */ ExternalSystemTaskId $id;
                {
                    this.$id = $id;
                }

                public void onImportStarted(@Nullable String projectPath) {
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle data import stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFinished(@Nullable String projectPath) {
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle data import stage finished with success: " + this.$id.getIdeProjectId());
                }

                public void onFinalTasksFinished(@Nullable String projectPath) {
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle data import(final tasks) stage finished: " + this.$id.getIdeProjectId());
                }

                public void onFinalTasksStarted(@Nullable String projectPath) {
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle data import(final tasks) stage started: " + this.$id.getIdeProjectId());
                }

                public void onImportFailed(@Nullable String projectPath, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle data import stage finished with failure: " + this.$id.getIdeProjectId());
                }
            });
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            GradleWarmupConfiguratorKt.access$getLOG$p().error("Gradle resolve stage finished with failure " + id.getIdeProjectId(), (Throwable)e);
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            GradleWarmupConfiguratorKt.access$getLOG$p().error("Gradle resolve stage canceled " + id.getIdeProjectId());
        }

        public void onStart(@NotNull ExternalSystemTaskId id, @NotNull String workingDir) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (!GradleWarmupConfiguratorKt.access$isGradleProjectResolveTask(id)) {
                return;
            }
            GradleWarmupConfiguratorKt.access$getLOG$p().info("Gradle resolve stage started " + id.getIdeProjectId() + ", working dir: " + workingDir);
        }
    }
}

