/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.PathMapper;
import com.intellij.util.ThreeState;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.internal.consumer.CancellationTokenInternal;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.execution.target.TargetGradleConnector;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 !2\u00020\u0001:\u0004!\"#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0016J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002R4\u0010\u0005\u001a(\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b \n*\u0012\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cancellationTokens", "", "Lorg/gradle/initialization/BuildCancellationToken;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "connectorsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$GradleProjectConnection;", "shutdownStarted", "Lcom/intellij/util/ThreeState;", "canBeReused", "", "projectConnection", "connectorParams", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "disconnectGradleConnections", "", "dispose", "getConnection", "Lorg/gradle/tooling/ProjectConnection;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "gracefulStopDaemons", "stopIdleDaemonsOfOldVersions", "Companion", "ConnectorParams", "GradleProjectConnection", "NonClosableConnection", "intellij.gradle.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleConnectorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleConnectorService.kt\norg/jetbrains/plugins/gradle/GradleConnectorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,313:1\n766#2:314\n857#2,2:315\n1855#2,2:317\n1855#2,2:319\n10#3:321\n*S KotlinDebug\n*F\n+ 1 GradleConnectorService.kt\norg/jetbrains/plugins/gradle/GradleConnectorService\n*L\n72#1:314\n72#1:315,2\n91#1:317,2\n107#1:319,2\n180#1:321\n*E\n"})
public final class GradleConnectorService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, GradleProjectConnection> connectorsMap;
    @NotNull
    private final Set<BuildCancellationToken> cancellationTokens;
    @NotNull
    private volatile ThreeState shutdownStarted;
    @NotNull
    private static final Logger LOG;
    private static final boolean DISABLE_STOP_OLD_IDLE_DAEMONS;
    private static final boolean USE_PRODUCTION_TTL_FOR_TESTS;

    public GradleConnectorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.connectorsMap = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.cancellationTokens = set;
        this.shutdownStarted = ThreeState.UNSURE;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void start() {
                shutdownStarted = ThreeState.YES;
                super.start();
            }
        });
    }

    public void dispose() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.disconnectGradleConnections();
        this.stopIdleDaemonsOfOldVersions();
    }

    /*
     * WARNING - void declaration
     */
    private final void stopIdleDaemonsOfOldVersions() {
        if (DISABLE_STOP_OLD_IDLE_DAEMONS) {
            return;
        }
        try {
            if (ProjectUtil.getOpenProjects().length == 0) {
                void $this$filterTo$iv$iv;
                GradleVersion gradleVersion_6_5 = GradleVersion.version((String)"6.5");
                List<DaemonState> list2 = GradleDaemonServices.getDaemonsStatus();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getDaemonsStatus(...)");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DaemonState it = (DaemonState)element$iv$iv;
                    boolean bl = false;
                    String string2 = it.getStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatus(...)");
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    boolean bl2 = Intrinsics.areEqual((Object)string3, (Object)"idle") && GradleVersion.version((String)it.getVersion()).compareTo(gradleVersion_6_5) < 0;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List idleDaemons = (List)destination$iv$iv;
                if (!((Collection)idleDaemons).isEmpty()) {
                    GradleDaemonServices.stopDaemons(idleDaemons);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to stop Gradle daemons during project close", (Throwable)e);
        }
    }

    private final void disconnectGradleConnections() {
        if (this.shutdownStarted != ThreeState.YES) {
            try {
                Collection<GradleProjectConnection> collection = this.connectorsMap.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GradleProjectConnection p0 = (GradleProjectConnection)element$iv;
                    boolean bl = false;
                    p0.disconnect();
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to disconnect Gradle connections during project close", t);
                this.gracefulStopDaemons();
            }
        } else {
            this.gracefulStopDaemons();
        }
        this.cancellationTokens.clear();
        this.connectorsMap.clear();
    }

    private final void gracefulStopDaemons() {
        Iterable $this$forEach$iv = this.cancellationTokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildCancellationToken it = (BuildCancellationToken)element$iv;
            boolean bl = false;
            if (it.isCancellationRequested()) continue;
            try {
                it.cancel();
            }
            catch (Throwable t) {
                LOG.warn("Failed to cancel build", t);
            }
        }
        GradleDaemonServices.gracefulStopDaemons();
    }

    private final ProjectConnection getConnection(ConnectorParams connectorParams, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
        GradleProjectConnection gradleProjectConnection = this.connectorsMap.compute(connectorParams.getProjectPath(), (arg_0, arg_1) -> GradleConnectorService.getConnection$lambda$2((Function2)new Function2<String, GradleProjectConnection, GradleProjectConnection>(this, connectorParams, taskId, listener2){
            final /* synthetic */ GradleConnectorService this$0;
            final /* synthetic */ ConnectorParams $connectorParams;
            final /* synthetic */ ExternalSystemTaskId $taskId;
            final /* synthetic */ ExternalSystemTaskNotificationListener $listener;
            {
                this.this$0 = $receiver;
                this.$connectorParams = $connectorParams;
                this.$taskId = $taskId;
                this.$listener = $listener;
                super(2);
            }

            @Nullable
            public final GradleProjectConnection invoke(@NotNull String string2, @Nullable GradleProjectConnection conn) {
                GradleConnector newConnector;
                ProjectConnection newConnection;
                Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 0>");
                if (conn != null) {
                    if (GradleConnectorService.access$canBeReused(this.this$0, conn, this.$connectorParams)) {
                        return conn;
                    }
                    ProjectConnection projectConnection = conn.getConnection();
                    Intrinsics.checkNotNull((Object)projectConnection, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.GradleConnectorService.NonClosableConnection");
                    NonClosableConnection unwrappedConnection = (NonClosableConnection)projectConnection;
                    ApplicationManager.getApplication().executeOnPooledThread(() -> getConnection.1.invoke$lambda$0(unwrappedConnection));
                }
                boolean bl = (newConnection = (newConnector = org.jetbrains.plugins.gradle.GradleConnectorService$Companion.access$createConnector(GradleConnectorService.Companion, this.$connectorParams, this.$taskId, this.$listener)).connect()) != null;
                ConnectorParams connectorParams = this.$connectorParams;
                if (!bl) {
                    boolean bl2 = false;
                    String string3 = "Can't create connection to the target project via gradle tooling api. Project path: '" + connectorParams.getProjectPath() + "'";
                    throw new IllegalStateException(string3.toString());
                }
                Intrinsics.checkNotNull((Object)newConnection);
                NonClosableConnection wrappedConnection = new NonClosableConnection(newConnection);
                return new GradleProjectConnection(this.$connectorParams, newConnector, wrappedConnection);
            }

            private static final void invoke$lambda$0(NonClosableConnection $unwrappedConnection) {
                Intrinsics.checkNotNullParameter((Object)$unwrappedConnection, (String)"$unwrappedConnection");
                $unwrappedConnection.getDelegate().close();
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)gradleProjectConnection);
        return gradleProjectConnection.getConnection();
    }

    private final boolean canBeReused(GradleProjectConnection projectConnection, ConnectorParams connectorParams) {
        if (connectorParams.getGradleHome() == null) {
            return false;
        }
        if (projectConnection.getConnector() instanceof TargetGradleConnector) {
            return false;
        }
        return Intrinsics.areEqual((Object)connectorParams, (Object)projectConnection.getParams());
    }

    private static final GradleProjectConnection getConnection$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GradleProjectConnection)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    private static final GradleConnectorService getInstance(String projectPath, ExternalSystemTaskId taskId) {
        return GradleConnectorService.Companion.getInstance(projectPath, taskId);
    }

    @JvmStatic
    public static final <R> R withGradleConnection(@NotNull String projectPath, @Nullable ExternalSystemTaskId taskId, @Nullable GradleExecutionSettings executionSettings, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<ProjectConnection, R> function) {
        return Companion.withGradleConnection(projectPath, taskId, executionSettings, listener2, cancellationToken, function);
    }

    public static final /* synthetic */ boolean access$canBeReused(GradleConnectorService $this, GradleProjectConnection projectConnection, ConnectorParams connectorParams) {
        return $this.canBeReused(projectConnection, connectorParams);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleConnectorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DISABLE_STOP_OLD_IDLE_DAEMONS = Boolean.getBoolean("idea.gradle.disableStopIdleDaemonsOnProjectClose");
        USE_PRODUCTION_TTL_FOR_TESTS = Boolean.getBoolean("gradle.connector.useExternalSystemRemoteProcessIdleTtlForTests");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0003J]\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00150\u001bH\u0007\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$Companion;", "", "()V", "DISABLE_STOP_OLD_IDLE_DAEMONS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "USE_PRODUCTION_TTL_FOR_TESTS", "createConnector", "Lorg/gradle/tooling/GradleConnector;", "connectorParams", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "getInstance", "Lorg/jetbrains/plugins/gradle/GradleConnectorService;", "projectPath", "", "withGradleConnection", "R", "executionSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "cancellationToken", "Lorg/gradle/tooling/CancellationToken;", "function", "Ljava/util/function/Function;", "Lorg/gradle/tooling/ProjectConnection;", "(Ljava/lang/String;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;Lorg/gradle/tooling/CancellationToken;Ljava/util/function/Function;)Ljava/lang/Object;", "intellij.gradle.common"})
    @SourceDebugExtension(value={"SMAP\nGradleConnectorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleConnectorService.kt\norg/jetbrains/plugins/gradle/GradleConnectorService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final GradleConnectorService getInstance(String projectPath, ExternalSystemTaskId taskId) {
            Project project;
            ExternalSystemTaskId externalSystemTaskId = taskId;
            Object object = project = externalSystemTaskId != null ? externalSystemTaskId.findProject() : null;
            if (project == null) {
                for (Project openProject : ProjectUtil.getOpenProjects()) {
                    String projectBasePath;
                    if (openProject.getBasePath() == null || !FileUtil.isAncestor((String)projectBasePath, (String)projectPath, (boolean)false)) continue;
                    project = openProject;
                    break;
                }
            }
            Project project2 = project;
            return project2 != null ? (GradleConnectorService)project2.getService(GradleConnectorService.class) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <R> R withGradleConnection(@NotNull String projectPath, @Nullable ExternalSystemTaskId taskId, @Nullable GradleExecutionSettings executionSettings, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<ProjectConnection, R> function) {
            R r;
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            GradleExecutionSettings gradleExecutionSettings = executionSettings;
            TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = gradleExecutionSettings != null ? ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)gradleExecutionSettings) : null;
            GradleExecutionSettings gradleExecutionSettings2 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings3 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings4 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings5 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings6 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings7 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings8 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings9 = executionSettings;
            ConnectorParams connectionParams = new ConnectorParams(projectPath, gradleExecutionSettings2 != null ? gradleExecutionSettings2.getServiceDirectory() : null, gradleExecutionSettings3 != null ? gradleExecutionSettings3.getDistributionType() : null, gradleExecutionSettings4 != null ? gradleExecutionSettings4.getGradleHome() : null, gradleExecutionSettings5 != null ? gradleExecutionSettings5.getJavaHome() : null, gradleExecutionSettings6 != null ? gradleExecutionSettings6.getWrapperPropertyFile() : null, gradleExecutionSettings7 != null ? Boolean.valueOf(gradleExecutionSettings7.isVerboseProcessing()) : null, gradleExecutionSettings8 != null ? Integer.valueOf((int)gradleExecutionSettings8.getRemoteProcessIdleTtlInMs()) : null, targetEnvironmentConfigurationProvider, gradleExecutionSettings9 != null ? (RunConfigurationTaskState)gradleExecutionSettings9.getUserData(RunConfigurationTaskState.Companion.getKEY()) : null);
            GradleConnectorService connectionService = this.getInstance(projectPath, taskId);
            if (connectionService != null) {
                BuildCancellationToken buildCancellationToken;
                CancellationTokenInternal cancellationTokenInternal = cancellationToken instanceof CancellationTokenInternal ? (CancellationTokenInternal)cancellationToken : null;
                BuildCancellationToken buildCancellationToken2 = buildCancellationToken = cancellationTokenInternal != null ? cancellationTokenInternal.getToken() : null;
                if (buildCancellationToken2 != null) {
                    BuildCancellationToken it = buildCancellationToken2;
                    boolean bl = false;
                    connectionService.cancellationTokens.add(it);
                }
                try {
                    Closeable closeable;
                    Object object;
                    ProjectConnection connection = connectionService.getConnection(connectionParams, taskId, listener2);
                    if (connection instanceof NonClosableConnection) {
                        object = function.apply(connection);
                    } else {
                        closeable = (Closeable)connection;
                        Throwable bl = null;
                        try {
                            Object p0 = (ProjectConnection)closeable;
                            boolean bl2 = false;
                            p0 = function.apply((ProjectConnection)p0);
                            object = p0;
                        }
                        catch (Throwable p0) {
                            bl = p0;
                            throw p0;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)bl);
                        }
                    }
                    closeable = object;
                    return (R)closeable;
                }
                finally {
                    BuildCancellationToken buildCancellationToken3 = buildCancellationToken;
                    if (buildCancellationToken3 != null) {
                        BuildCancellationToken it = buildCancellationToken3;
                        boolean bl = false;
                        connectionService.cancellationTokens.remove(it);
                    }
                }
            }
            GradleConnector newConnector = this.createConnector(connectionParams, taskId, listener2);
            ProjectConnection connection = newConnector.connect();
            Closeable closeable = (Closeable)connection;
            Throwable throwable = null;
            try {
                ProjectConnection p0 = (ProjectConnection)closeable;
                boolean bl = false;
                r = function.apply(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return r;
        }

        public static /* synthetic */ Object withGradleConnection$default(Companion companion, String string2, ExternalSystemTaskId externalSystemTaskId, GradleExecutionSettings gradleExecutionSettings, ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener, CancellationToken cancellationToken, Function function, int n, Object object) {
            if ((n & 4) != 0) {
                gradleExecutionSettings = null;
            }
            if ((n & 8) != 0) {
                externalSystemTaskNotificationListener = null;
            }
            if ((n & 0x10) != 0) {
                cancellationToken = null;
            }
            return companion.withGradleConnection(string2, externalSystemTaskId, gradleExecutionSettings, externalSystemTaskNotificationListener, cancellationToken, function);
        }

        private final GradleConnector createConnector(ConnectorParams connectorParams, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
            int ttl;
            GradleConnector connector = null;
            if (connectorParams.getEnvironmentConfigurationProvider() != null) {
                connector = new TargetGradleConnector(connectorParams.getEnvironmentConfigurationProvider(), taskId, listener2, connectorParams.getTaskState());
            } else {
                GradleConnector gradleConnector = GradleConnector.newConnector();
                Intrinsics.checkNotNullExpressionValue((Object)gradleConnector, (String)"newConnector(...)");
                connector = gradleConnector;
            }
            File projectDir = new File(connectorParams.getProjectPath());
            String localPathToGradleUserHome = connectorParams.getServiceDirectory();
            if (connectorParams.getDistributionType() == DistributionType.LOCAL) {
                String localPathToGradleHome = connectorParams.getGradleHome();
                if (localPathToGradleHome != null) {
                    if (connector instanceof TargetGradleConnector) {
                        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = connectorParams.getEnvironmentConfigurationProvider();
                        PathMapper targetPathMapper = targetEnvironmentConfigurationProvider != null ? targetEnvironmentConfigurationProvider.getPathMapper() : null;
                        String targetGradleHomePath = GradleTargetUtil.maybeConvertToRemote(targetPathMapper, localPathToGradleHome);
                        TargetGradleConnector targetGradleConnector = (TargetGradleConnector)connector;
                        TargetValue targetValue = TargetValue.create((Object)localPathToGradleHome, (Promise)Promises.resolvedPromise((Object)targetGradleHomePath));
                        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
                        targetGradleConnector.useInstallation((TargetValue<String>)targetValue);
                    } else {
                        connector.useInstallation(new File(localPathToGradleHome));
                    }
                }
            } else if (connectorParams.getDistributionType() == DistributionType.WRAPPED && connectorParams.getWrapperPropertyFile() != null) {
                File file;
                String string2 = localPathToGradleUserHome;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    file = new File(localPathToGradleUserHome);
                } else {
                    file = null;
                }
                File gradleUserHomeLocalFile = file;
                DistributionFactoryExt.setWrappedDistribution(connector, connectorParams.getWrapperPropertyFile());
            }
            if (localPathToGradleUserHome != null) {
                if (connector instanceof TargetGradleConnector) {
                    TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = connectorParams.getEnvironmentConfigurationProvider();
                    PathMapper targetPathMapper = targetEnvironmentConfigurationProvider != null ? targetEnvironmentConfigurationProvider.getPathMapper() : null;
                    String targetGradleUserHomePath = GradleTargetUtil.maybeConvertToRemote(targetPathMapper, localPathToGradleUserHome);
                    TargetGradleConnector targetGradleConnector = (TargetGradleConnector)connector;
                    TargetValue targetValue = TargetValue.create((Object)localPathToGradleUserHome, (Promise)Promises.resolvedPromise((Object)targetGradleUserHomePath));
                    Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
                    targetGradleConnector.useGradleUserHomeDir((TargetValue<String>)targetValue);
                } else {
                    connector.useGradleUserHomeDir(new File(localPathToGradleUserHome));
                }
            }
            if (Intrinsics.areEqual((Object)connectorParams.getVerboseProcessing(), (Object)true) && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            Application app = ApplicationManager.getApplication();
            if (!USE_PRODUCTION_TTL_FOR_TESTS && app != null && app.isUnitTestMode()) {
                v9 = 10000;
            } else {
                Integer n = connectorParams.getTtlMs();
                v9 = ttl = n != null ? n : -1;
            }
            if (ttl > 0 && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
            }
            connector.forProjectDirectory(projectDir);
            return connector;
        }

        public static final /* synthetic */ GradleConnector access$createConnector(Companion $this, ConnectorParams connectorParams, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
            return $this.createConnector(connectorParams, taskId, listener2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\b\u0082\b\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\"J\u0010\u0010-\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001fJ\u000b\u0010.\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u0084\u0001\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001\u00a2\u0006\u0002\u00100J\u0013\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00103\u001a\u00020\rH\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0018\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "", "projectPath", "", "serviceDirectory", "distributionType", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "gradleHome", "javaHome", "wrapperPropertyFile", "verboseProcessing", "", "ttlMs", "", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "taskState", "Lcom/intellij/task/RunConfigurationTaskState;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;Lcom/intellij/task/RunConfigurationTaskState;)V", "getDistributionType", "()Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "getEnvironmentConfigurationProvider", "()Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "getGradleHome", "()Ljava/lang/String;", "getJavaHome", "getProjectPath", "getServiceDirectory", "getTaskState", "()Lcom/intellij/task/RunConfigurationTaskState;", "getTtlMs", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getVerboseProcessing", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getWrapperPropertyFile", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;Lcom/intellij/task/RunConfigurationTaskState;)Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "equals", "other", "hashCode", "toString", "intellij.gradle.common"})
    private static final class ConnectorParams {
        @NotNull
        private final String projectPath;
        @Nullable
        private final String serviceDirectory;
        @Nullable
        private final DistributionType distributionType;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;
        @Nullable
        private final String wrapperPropertyFile;
        @Nullable
        private final Boolean verboseProcessing;
        @Nullable
        private final Integer ttlMs;
        @Nullable
        private final TargetEnvironmentConfigurationProvider environmentConfigurationProvider;
        @Nullable
        private final RunConfigurationTaskState taskState;

        public ConnectorParams(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome2, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider, @Nullable RunConfigurationTaskState taskState) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.serviceDirectory = serviceDirectory;
            this.distributionType = distributionType;
            this.gradleHome = gradleHome2;
            this.javaHome = javaHome;
            this.wrapperPropertyFile = wrapperPropertyFile;
            this.verboseProcessing = verboseProcessing;
            this.ttlMs = ttlMs;
            this.environmentConfigurationProvider = environmentConfigurationProvider;
            this.taskState = taskState;
        }

        @NotNull
        public final String getProjectPath() {
            return this.projectPath;
        }

        @Nullable
        public final String getServiceDirectory() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType getDistributionType() {
            return this.distributionType;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        @Nullable
        public final String getWrapperPropertyFile() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean getVerboseProcessing() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer getTtlMs() {
            return this.ttlMs;
        }

        @Nullable
        public final TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider() {
            return this.environmentConfigurationProvider;
        }

        @Nullable
        public final RunConfigurationTaskState getTaskState() {
            return this.taskState;
        }

        @NotNull
        public final String component1() {
            return this.projectPath;
        }

        @Nullable
        public final String component2() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType component3() {
            return this.distributionType;
        }

        @Nullable
        public final String component4() {
            return this.gradleHome;
        }

        @Nullable
        public final String component5() {
            return this.javaHome;
        }

        @Nullable
        public final String component6() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean component7() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer component8() {
            return this.ttlMs;
        }

        @Nullable
        public final TargetEnvironmentConfigurationProvider component9() {
            return this.environmentConfigurationProvider;
        }

        @Nullable
        public final RunConfigurationTaskState component10() {
            return this.taskState;
        }

        @NotNull
        public final ConnectorParams copy(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome2, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider, @Nullable RunConfigurationTaskState taskState) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return new ConnectorParams(projectPath, serviceDirectory, distributionType, gradleHome2, javaHome, wrapperPropertyFile, verboseProcessing, ttlMs, environmentConfigurationProvider, taskState);
        }

        public static /* synthetic */ ConnectorParams copy$default(ConnectorParams connectorParams, String string2, String string3, DistributionType distributionType, String string4, String string5, String string6, Boolean bl, Integer n, TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider, RunConfigurationTaskState runConfigurationTaskState, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = connectorParams.projectPath;
            }
            if ((n2 & 2) != 0) {
                string3 = connectorParams.serviceDirectory;
            }
            if ((n2 & 4) != 0) {
                distributionType = connectorParams.distributionType;
            }
            if ((n2 & 8) != 0) {
                string4 = connectorParams.gradleHome;
            }
            if ((n2 & 0x10) != 0) {
                string5 = connectorParams.javaHome;
            }
            if ((n2 & 0x20) != 0) {
                string6 = connectorParams.wrapperPropertyFile;
            }
            if ((n2 & 0x40) != 0) {
                bl = connectorParams.verboseProcessing;
            }
            if ((n2 & 0x80) != 0) {
                n = connectorParams.ttlMs;
            }
            if ((n2 & 0x100) != 0) {
                targetEnvironmentConfigurationProvider = connectorParams.environmentConfigurationProvider;
            }
            if ((n2 & 0x200) != 0) {
                runConfigurationTaskState = connectorParams.taskState;
            }
            return connectorParams.copy(string2, string3, distributionType, string4, string5, string6, bl, n, targetEnvironmentConfigurationProvider, runConfigurationTaskState);
        }

        @NotNull
        public String toString() {
            return "ConnectorParams(projectPath=" + this.projectPath + ", serviceDirectory=" + this.serviceDirectory + ", distributionType=" + this.distributionType + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ", wrapperPropertyFile=" + this.wrapperPropertyFile + ", verboseProcessing=" + this.verboseProcessing + ", ttlMs=" + this.ttlMs + ", environmentConfigurationProvider=" + this.environmentConfigurationProvider + ", taskState=" + this.taskState + ")";
        }

        public int hashCode() {
            int result = this.projectPath.hashCode();
            result = result * 31 + (this.serviceDirectory == null ? 0 : this.serviceDirectory.hashCode());
            result = result * 31 + (this.distributionType == null ? 0 : this.distributionType.hashCode());
            result = result * 31 + (this.gradleHome == null ? 0 : this.gradleHome.hashCode());
            result = result * 31 + (this.javaHome == null ? 0 : this.javaHome.hashCode());
            result = result * 31 + (this.wrapperPropertyFile == null ? 0 : this.wrapperPropertyFile.hashCode());
            result = result * 31 + (this.verboseProcessing == null ? 0 : ((Object)this.verboseProcessing).hashCode());
            result = result * 31 + (this.ttlMs == null ? 0 : ((Object)this.ttlMs).hashCode());
            result = result * 31 + (this.environmentConfigurationProvider == null ? 0 : this.environmentConfigurationProvider.hashCode());
            result = result * 31 + (this.taskState == null ? 0 : this.taskState.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectorParams)) {
                return false;
            }
            ConnectorParams connectorParams = (ConnectorParams)other;
            if (!Intrinsics.areEqual((Object)this.projectPath, (Object)connectorParams.projectPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serviceDirectory, (Object)connectorParams.serviceDirectory)) {
                return false;
            }
            if (this.distributionType != connectorParams.distributionType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gradleHome, (Object)connectorParams.gradleHome)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.javaHome, (Object)connectorParams.javaHome)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wrapperPropertyFile, (Object)connectorParams.wrapperPropertyFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.verboseProcessing, (Object)connectorParams.verboseProcessing)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ttlMs, (Object)connectorParams.ttlMs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.environmentConfigurationProvider, (Object)connectorParams.environmentConfigurationProvider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.taskState, (Object)connectorParams.taskState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$GradleProjectConnection;", "", "params", "Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "connector", "Lorg/gradle/tooling/GradleConnector;", "connection", "Lorg/gradle/tooling/ProjectConnection;", "(Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;Lorg/gradle/tooling/GradleConnector;Lorg/gradle/tooling/ProjectConnection;)V", "getConnection", "()Lorg/gradle/tooling/ProjectConnection;", "getConnector", "()Lorg/gradle/tooling/GradleConnector;", "getParams", "()Lorg/jetbrains/plugins/gradle/GradleConnectorService$ConnectorParams;", "disconnect", "", "intellij.gradle.common"})
    private static final class GradleProjectConnection {
        @NotNull
        private final ConnectorParams params;
        @NotNull
        private final GradleConnector connector;
        @NotNull
        private final ProjectConnection connection;

        public GradleProjectConnection(@NotNull ConnectorParams params, @NotNull GradleConnector connector, @NotNull ProjectConnection connection) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            this.params = params;
            this.connector = connector;
            this.connection = connection;
        }

        @NotNull
        public final ConnectorParams getParams() {
            return this.params;
        }

        @NotNull
        public final GradleConnector getConnector() {
            return this.connector;
        }

        @NotNull
        public final ProjectConnection getConnection() {
            return this.connection;
        }

        public final void disconnect() {
            this.connector.disconnect();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001Jk\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\t0\t\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\r0\rH\u0096\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016JT\u0010\u0010\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010\u0012Jw\u0010\u0010\u001a\u00020\u000f\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u00112.\u0010\u0013\u001a*\u0012\u000e\b\u0000\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0014\u0012\u000e\b\u0000\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00140\u0014H\u0096\u0001Jk\u0010\u0015\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00160\u0016\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u0001H\nH\n\u0018\u00010\u00110\u0011H\u0096\u0001J\u0011\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\n \b*\u0004\u0018\u00010\u001a0\u001aH\u0096\u0001J5\u0010\u001b\u001a\u00020\u000f2*\u0010\f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u001d0\u001d \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001e0\u001cH\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/GradleConnectorService$NonClosableConnection;", "Lorg/gradle/tooling/ProjectConnection;", "delegate", "(Lorg/gradle/tooling/ProjectConnection;)V", "getDelegate", "()Lorg/gradle/tooling/ProjectConnection;", "action", "Lorg/gradle/tooling/BuildActionExecuter$Builder;", "kotlin.jvm.PlatformType", "Lorg/gradle/tooling/BuildActionExecuter;", "T", "", "p0", "Lorg/gradle/tooling/BuildAction;", "close", "", "getModel", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "p1", "Lorg/gradle/tooling/ResultHandler;", "model", "Lorg/gradle/tooling/ModelBuilder;", "newBuild", "Lorg/gradle/tooling/BuildLauncher;", "newTestLauncher", "Lorg/gradle/tooling/TestLauncher;", "notifyDaemonsAboutChangedPaths", "", "Ljava/nio/file/Path;", "", "intellij.gradle.common"})
    private static final class NonClosableConnection
    implements ProjectConnection {
        @NotNull
        private final ProjectConnection delegate;

        public NonClosableConnection(@NotNull ProjectConnection delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final ProjectConnection getDelegate() {
            return this.delegate;
        }

        public BuildActionExecuter.Builder action() {
            return this.delegate.action();
        }

        public <T> BuildActionExecuter<T> action(BuildAction<T> p0) {
            return this.delegate.action(p0);
        }

        public <T> T getModel(Class<T> p0) {
            return (T)this.delegate.getModel(p0);
        }

        public <T> void getModel(Class<T> p0, ResultHandler<? super T> p1) {
            this.delegate.getModel(p0, p1);
        }

        public <T> ModelBuilder<T> model(Class<T> p0) {
            return this.delegate.model(p0);
        }

        public BuildLauncher newBuild() {
            return this.delegate.newBuild();
        }

        public TestLauncher newTestLauncher() {
            return this.delegate.newTestLauncher();
        }

        public void notifyDaemonsAboutChangedPaths(List<Path> p0) {
            this.delegate.notifyDaemonsAboutChangedPaths(p0);
        }

        public void close() {
            throw new IllegalStateException("This connection should not be closed explicitly.");
        }
    }
}

