/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.workflow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaRunContext;
import org.jetbrains.qodana.staticAnalysis.stat.QodanaProjectInfoCollector;
import org.jetbrains.qodana.staticAnalysis.workflow.GitCommitsSummaryLogger;
import org.jetbrains.qodana.staticAnalysis.workflow.QodanaWorkflowExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/workflow/GitCommitsSummaryLogger;", "Lorg/jetbrains/qodana/staticAnalysis/workflow/QodanaWorkflowExtension;", "()V", "beforeLaunch", "", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaRunContext;", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaRunContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commitsSummarySince", "Lorg/jetbrains/qodana/staticAnalysis/workflow/GitCommitsSummaryLogger$CommitsSummary;", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Lgit4idea/repo/GitRepository;", "since", "", "CommitsSummary", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nGitCommitsSummaryLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitsSummaryLogger.kt\norg/jetbrains/qodana/staticAnalysis/workflow/GitCommitsSummaryLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n8#2:82\n*S KotlinDebug\n*F\n+ 1 GitCommitsSummaryLogger.kt\norg/jetbrains/qodana/staticAnalysis/workflow/GitCommitsSummaryLogger\n*L\n53#1:82\n*E\n"})
public final class GitCommitsSummaryLogger
implements QodanaWorkflowExtension {
    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object beforeLaunch(@NotNull QodanaRunContext var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof beforeLaunch.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GitCommitsSummaryLogger this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.beforeLaunch(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                project = context.getProject();
                v0 = GitRepositoryManager.getInstance((Project)project).getRepositories();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRepositories(...)");
                repos = v0;
                if (repos.size() == 0) {
                    QodanaProjectInfoCollector.Companion.logAbsentHistorySummary(project);
                    return Unit.INSTANCE;
                }
                repo = (GitRepository)repos.get(0);
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.label = 1;
                v1 = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function0)((Function0)new Function0<Unit>(this, project, repo){
                    final /* synthetic */ GitCommitsSummaryLogger this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GitRepository $repo;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$repo = $repo;
                        super(0);
                    }

                    public final void invoke() {
                        GitRepository gitRepository = this.$repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"$repo");
                        CommitsSummary summary30 = GitCommitsSummaryLogger.access$commitsSummarySince(this.this$0, this.$project, gitRepository, "30 days ago");
                        GitRepository gitRepository2 = this.$repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository2, (String)"$repo");
                        CommitsSummary summary60 = GitCommitsSummaryLogger.access$commitsSummarySince(this.this$0, this.$project, gitRepository2, "60 days ago");
                        GitRepository gitRepository3 = this.$repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository3, (String)"$repo");
                        CommitsSummary summary90 = GitCommitsSummaryLogger.access$commitsSummarySince(this.this$0, this.$project, gitRepository3, "90 days ago");
                        QodanaProjectInfoCollector.Companion.logCommitsSummary(this.$project, summary30.getAuthors(), summary60.getAuthors(), summary90.getAuthors(), summary30.getCommits(), summary60.getCommits(), summary90.getCommits());
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var10_5) goto lbl28
lbl27:
                // 1 sources

                return var10_5;
lbl28:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                project = (Project)$continuation.L$1;
                this = (GitCommitsSummaryLogger)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                }
                catch (VcsException e) {
                    QodanaProjectInfoCollector.Companion.logAbsentHistorySummary(project);
                    $i$f$thisLogger = false;
                    v2 = Logger.getInstance(GitCommitsSummaryLogger.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn((Throwable)e);
                }
lbl44:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CommitsSummary commitsSummarySince(Project project2, GitRepository repo, String since) throws VcsException {
        GitLineHandler handler = new GitLineHandler(project2, repo.getRoot(), GitCommand.SHORTLOG);
        handler.setSilent(true);
        String[] stringArray = new String[]{"-s", "--since", since, "HEAD"};
        handler.addParameters(stringArray);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result = gitCommandResult;
        result.throwOnError(new int[0]);
        int commits2 = 0;
        for (String line : result.getOutput()) {
            Intrinsics.checkNotNull((Object)line);
            Object[] objectArray = (Object[])((Object)StringsKt.trim((CharSequence)line)).toString();
            Object[] objectArray2 = new Regex("\\W");
            int n = 0;
            List split = objectArray2.split((CharSequence)objectArray, n);
            if (split.isEmpty()) {
                objectArray = new Object[]{line};
                throw new VcsException(QodanaBundle.message("wrong.git.shortlog.response", objectArray));
            }
            try {
                commits2 += Integer.parseInt((String)split.get(0));
            }
            catch (NumberFormatException e) {
                objectArray2 = new Object[]{line};
                throw new VcsException(QodanaBundle.message("wrong.git.shortlog.response", objectArray2), (Throwable)e);
            }
        }
        return new CommitsSummary(commits2, result.getOutput().size());
    }

    public static final /* synthetic */ CommitsSummary access$commitsSummarySince(GitCommitsSummaryLogger $this, Project project2, GitRepository repo, String since) {
        return $this.commitsSummarySince(project2, repo, since);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/workflow/GitCommitsSummaryLogger$CommitsSummary;", "", "commits", "", "authors", "(II)V", "getAuthors", "()I", "getCommits", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.qodana"})
    private static final class CommitsSummary {
        private final int commits;
        private final int authors;

        public CommitsSummary(int commits2, int authors) {
            this.commits = commits2;
            this.authors = authors;
        }

        public final int getCommits() {
            return this.commits;
        }

        public final int getAuthors() {
            return this.authors;
        }

        public final int component1() {
            return this.commits;
        }

        public final int component2() {
            return this.authors;
        }

        @NotNull
        public final CommitsSummary copy(int commits2, int authors) {
            return new CommitsSummary(commits2, authors);
        }

        public static /* synthetic */ CommitsSummary copy$default(CommitsSummary commitsSummary, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = commitsSummary.commits;
            }
            if ((n3 & 2) != 0) {
                n2 = commitsSummary.authors;
            }
            return commitsSummary.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CommitsSummary(commits=" + this.commits + ", authors=" + this.authors + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.commits);
            result = result * 31 + Integer.hashCode(this.authors);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitsSummary)) {
                return false;
            }
            CommitsSummary commitsSummary = (CommitsSummary)other;
            if (this.commits != commitsSummary.commits) {
                return false;
            }
            return this.authors == commitsSummary.authors;
        }
    }
}

