/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.action;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.launcher.cli.WelcomeMessageConfiguration;
import org.gradle.api.launcher.cli.WelcomeMessageDisplayMode;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.RunDefaultTasksExecutionRequest;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.buildoption.Option;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.internal.watch.registry.WatchMode;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.consumer.DefaultTaskSpec;
import org.gradle.tooling.internal.consumer.DefaultTestSpec;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestSpec;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.action.ExecuteBuildAction;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.SerializedPayloadSerializer;

public class BuildActionSerializer {
    public static Serializer<BuildAction> create() {
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(ExecuteBuildAction.class, new ExecuteBuildActionSerializer());
        registry.register(BuildModelAction.class, new BuildModelActionSerializer());
        registry.register(ClientProvidedBuildAction.class, new ClientProvidedBuildActionSerializer());
        registry.register(ClientProvidedPhasedAction.class, new ClientProvidedPhasedActionSerializer());
        registry.register(TestExecutionRequestAction.class, new TestExecutionRequestActionSerializer());
        registry.register(InternalTaskSpec.class, new InternalTaskSpecSerializer());
        return registry.build(BuildAction.class);
    }

    private static class NullableFileSerializer
    implements Serializer<File> {
        private NullableFileSerializer() {
        }

        @Override
        public void write(Encoder encoder, File value) throws Exception {
            if (value == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeString(value.getPath());
            }
        }

        @Override
        public File read(Decoder decoder) throws Exception {
            if (decoder.readBoolean()) {
                return new File(decoder.readString());
            }
            return null;
        }
    }

    private static class ValueSerializer
    implements Serializer<Option.Value<Boolean>> {
        private static final byte EXPLICIT_TRUE = 1;
        private static final byte EXPLICIT_FALSE = 2;
        public static final byte IMPLICIT_TRUE = 3;
        public static final byte IMPLICIT_FALSE = 4;

        private ValueSerializer() {
        }

        @Override
        public Option.Value<Boolean> read(Decoder decoder) throws Exception {
            switch (decoder.readByte()) {
                case 1: {
                    return Option.Value.value(true);
                }
                case 2: {
                    return Option.Value.value(false);
                }
                case 3: {
                    return Option.Value.defaultValue(true);
                }
                case 4: {
                    return Option.Value.defaultValue(false);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void write(Encoder encoder, Option.Value<Boolean> value) throws Exception {
            if (value.isExplicit() && value.get().booleanValue()) {
                encoder.writeByte((byte)1);
            } else if (value.isExplicit()) {
                encoder.writeByte((byte)2);
            } else if (value.get().booleanValue()) {
                encoder.writeByte((byte)3);
            } else {
                encoder.writeByte((byte)4);
            }
        }
    }

    private static class BuildEventSubscriptionsSerializer
    implements Serializer<BuildEventSubscriptions> {
        private final Serializer<Set<OperationType>> setSerializer;

        public BuildEventSubscriptionsSerializer() {
            BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
            this.setSerializer = new SetSerializer<OperationType>(serializerFactory.getSerializerFor(OperationType.class));
        }

        @Override
        public void write(Encoder encoder, BuildEventSubscriptions value) throws Exception {
            this.setSerializer.write(encoder, value.getOperationTypes());
        }

        @Override
        public BuildEventSubscriptions read(Decoder decoder) throws Exception {
            return new BuildEventSubscriptions(this.setSerializer.read(decoder));
        }
    }

    private static class InternalTaskSpecSerializer
    implements Serializer<InternalTaskSpec> {
        private final Serializer<List<String>> stringListSerializer = new ListSerializer<String>(BaseSerializerFactory.STRING_SERIALIZER);

        private InternalTaskSpecSerializer() {
        }

        @Override
        public void write(Encoder encoder, InternalTaskSpec value) throws Exception {
            if (value instanceof InternalTestSpec) {
                encoder.writeSmallInt(0);
                InternalTestSpec test = (InternalTestSpec)value;
                encoder.writeString(value.getTaskPath());
                this.stringListSerializer.write(encoder, test.getClasses());
                this.stringListSerializer.write(encoder, test.getPatterns());
                this.stringListSerializer.write(encoder, test.getPackages());
                Map<String, List<String>> methods = test.getMethods();
                encoder.writeSmallInt(methods.size());
                for (Map.Entry<String, List<String>> entry : methods.entrySet()) {
                    String cls = entry.getKey();
                    List<String> method = entry.getValue();
                    encoder.writeString(cls);
                    this.stringListSerializer.write(encoder, method);
                }
            } else {
                encoder.writeSmallInt(1);
                encoder.writeString(value.getTaskPath());
            }
        }

        @Override
        public InternalTaskSpec read(Decoder decoder) throws Exception {
            int type = decoder.readSmallInt();
            if (type == 0) {
                String taskPath = decoder.readString();
                List<String> classes = this.stringListSerializer.read(decoder);
                List<String> patterns = this.stringListSerializer.read(decoder);
                List<String> packages = this.stringListSerializer.read(decoder);
                int methodsSize = decoder.readSmallInt();
                LinkedHashMap<String, List<String>> methods = new LinkedHashMap<String, List<String>>();
                for (int i = 0; i < methodsSize; ++i) {
                    String cls = decoder.readString();
                    List<String> method = this.stringListSerializer.read(decoder);
                    methods.put(cls, method);
                }
                return new DefaultTestSpec(taskPath, classes, methods, packages, patterns);
            }
            String taskPath = decoder.readString();
            return new DefaultTaskSpec(taskPath);
        }
    }

    private static class TestExecutionRequestActionSerializer
    implements Serializer<TestExecutionRequestAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();
        private final Serializer<TestExecutionRequestPayload> payloadSerializer = new DefaultSerializer<TestExecutionRequestPayload>();
        private final Serializer<InternalTaskSpec> taskSpecSerializer = new InternalTaskSpecSerializer();

        private TestExecutionRequestActionSerializer() {
        }

        @Override
        public void write(Encoder encoder, TestExecutionRequestAction value) throws Exception {
            this.startParameterSerializer.write(encoder, value.getStartParameter());
            this.buildEventSubscriptionsSerializer.write(encoder, value.getClientSubscriptions());
            this.payloadSerializer.write(encoder, new TestExecutionRequestPayload(value.getTestExecutionDescriptors(), value.getTestClassNames(), value.getInternalJvmTestRequests(), value.getDebugOptions(), value.getTaskAndTests(), value.isRunDefaultTasks()));
            encoder.writeSmallInt(value.getTaskSpecs().size());
            for (InternalTaskSpec taskSpec : value.getTaskSpecs()) {
                this.taskSpecSerializer.write(encoder, taskSpec);
            }
        }

        @Override
        public TestExecutionRequestAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = this.startParameterSerializer.read(decoder);
            BuildEventSubscriptions buildEventSubscriptions = this.buildEventSubscriptionsSerializer.read(decoder);
            TestExecutionRequestPayload payload = this.payloadSerializer.read(decoder);
            int numOfPatterns = decoder.readSmallInt();
            ArrayList<InternalTaskSpec> taskSpecs = new ArrayList<InternalTaskSpec>(numOfPatterns);
            for (int i = 0; i < numOfPatterns; ++i) {
                taskSpecs.add(i, this.taskSpecSerializer.read(decoder));
            }
            return new TestExecutionRequestAction(buildEventSubscriptions, startParameter, payload.testDescriptors, payload.classNames, payload.internalJvmTestRequests, payload.debugOptions, payload.taskAndTests, payload.isRunDefaultTasks, taskSpecs);
        }
    }

    private static class TestExecutionRequestPayload
    implements Serializable {
        final Set<InternalTestDescriptor> testDescriptors;
        final Set<String> classNames;
        final Set<InternalJvmTestRequest> internalJvmTestRequests;
        final InternalDebugOptions debugOptions;
        final Map<String, List<InternalJvmTestRequest>> taskAndTests;
        final boolean isRunDefaultTasks;

        public TestExecutionRequestPayload(Set<InternalTestDescriptor> testDescriptors, Set<String> classNames, Set<InternalJvmTestRequest> internalJvmTestRequests, InternalDebugOptions debugOptions, Map<String, List<InternalJvmTestRequest>> taskAndTests, boolean isRunDefaultTasks) {
            this.testDescriptors = testDescriptors;
            this.classNames = classNames;
            this.internalJvmTestRequests = internalJvmTestRequests;
            this.debugOptions = debugOptions;
            this.taskAndTests = taskAndTests;
            this.isRunDefaultTasks = isRunDefaultTasks;
        }
    }

    private static class ClientProvidedPhasedActionSerializer
    implements Serializer<ClientProvidedPhasedAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private ClientProvidedPhasedActionSerializer() {
        }

        @Override
        public void write(Encoder encoder, ClientProvidedPhasedAction value) throws Exception {
            this.startParameterSerializer.write(encoder, value.getStartParameter());
            this.payloadSerializer.write(encoder, value.getPhasedAction());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, value.getClientSubscriptions());
        }

        @Override
        public ClientProvidedPhasedAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = this.startParameterSerializer.read(decoder);
            SerializedPayload action = this.payloadSerializer.read(decoder);
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = this.buildEventSubscriptionsSerializer.read(decoder);
            return new ClientProvidedPhasedAction(startParameter, action, runTasks, buildEventSubscriptions);
        }
    }

    private static class ClientProvidedBuildActionSerializer
    implements Serializer<ClientProvidedBuildAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private ClientProvidedBuildActionSerializer() {
        }

        @Override
        public void write(Encoder encoder, ClientProvidedBuildAction value) throws Exception {
            this.startParameterSerializer.write(encoder, value.getStartParameter());
            this.payloadSerializer.write(encoder, value.getAction());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, value.getClientSubscriptions());
        }

        @Override
        public ClientProvidedBuildAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = this.startParameterSerializer.read(decoder);
            SerializedPayload action = this.payloadSerializer.read(decoder);
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = this.buildEventSubscriptionsSerializer.read(decoder);
            return new ClientProvidedBuildAction(startParameter, action, runTasks, buildEventSubscriptions);
        }
    }

    private static class BuildModelActionSerializer
    implements Serializer<BuildModelAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private BuildModelActionSerializer() {
        }

        @Override
        public void write(Encoder encoder, BuildModelAction value) throws Exception {
            this.startParameterSerializer.write(encoder, value.getStartParameter());
            encoder.writeString(value.getModelName());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, value.getClientSubscriptions());
        }

        @Override
        public BuildModelAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = this.startParameterSerializer.read(decoder);
            String modelName = decoder.readString();
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = this.buildEventSubscriptionsSerializer.read(decoder);
            return new BuildModelAction(startParameter, modelName, runTasks, buildEventSubscriptions);
        }
    }

    private static class ExecuteBuildActionSerializer
    implements Serializer<ExecuteBuildAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();

        private ExecuteBuildActionSerializer() {
        }

        @Override
        public void write(Encoder encoder, ExecuteBuildAction action) throws Exception {
            StartParameterInternal startParameter = action.getStartParameter();
            this.startParameterSerializer.write(encoder, startParameter);
        }

        @Override
        public ExecuteBuildAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = this.startParameterSerializer.read(decoder);
            return new ExecuteBuildAction(startParameter);
        }
    }

    private static class StartParameterSerializer
    implements Serializer<StartParameterInternal> {
        private final Serializer<LogLevel> logLevelSerializer;
        private final Serializer<ShowStacktrace> showStacktraceSerializer;
        private final Serializer<ConsoleOutput> consoleOutputSerializer;
        private final Serializer<WarningMode> warningModeSerializer;
        private final Serializer<File> nullableFileSerializer = new NullableFileSerializer();
        private final Serializer<List<String>> stringListSerializer = new ListSerializer<String>(BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<List<File>> fileListSerializer = new ListSerializer<File>(BaseSerializerFactory.FILE_SERIALIZER);
        private final Serializer<Set<String>> stringSetSerializer = new SetSerializer<String>(BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<Option.Value<Boolean>> valueSerializer = new ValueSerializer();

        StartParameterSerializer() {
            BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
            this.logLevelSerializer = serializerFactory.getSerializerFor(LogLevel.class);
            this.showStacktraceSerializer = serializerFactory.getSerializerFor(ShowStacktrace.class);
            this.consoleOutputSerializer = serializerFactory.getSerializerFor(ConsoleOutput.class);
            this.warningModeSerializer = serializerFactory.getSerializerFor(WarningMode.class);
        }

        @Override
        public void write(Encoder encoder, StartParameterInternal startParameter) throws Exception {
            this.logLevelSerializer.write(encoder, startParameter.getLogLevel());
            this.showStacktraceSerializer.write(encoder, startParameter.getShowStacktrace());
            this.consoleOutputSerializer.write(encoder, startParameter.getConsoleOutput());
            this.warningModeSerializer.write(encoder, startParameter.getWarningMode());
            encoder.writeBoolean(startParameter.isParallelProjectExecutionEnabled());
            encoder.writeSmallInt(startParameter.getMaxWorkerCount());
            this.writeTaskRequests(encoder, startParameter.getTaskRequests());
            this.stringSetSerializer.write(encoder, startParameter.getExcludedTaskNames());
            File customBuildFile = DeprecationLogger.whileDisabled(startParameter::getBuildFile);
            this.nullableFileSerializer.write(encoder, customBuildFile);
            this.nullableFileSerializer.write(encoder, startParameter.getProjectDir());
            File customSettingsFile = DeprecationLogger.whileDisabled(startParameter::getSettingsFile);
            this.nullableFileSerializer.write(encoder, customSettingsFile);
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, startParameter.getCurrentDir());
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, startParameter.getGradleUserHomeDir());
            this.nullableFileSerializer.write(encoder, startParameter.getGradleHomeDir());
            this.nullableFileSerializer.write(encoder, startParameter.getProjectCacheDir());
            this.fileListSerializer.write(encoder, startParameter.getIncludedBuilds());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, startParameter.getProjectProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, startParameter.getSystemPropertiesArgs());
            this.fileListSerializer.write(encoder, startParameter.getInitScripts());
            this.stringListSerializer.write(encoder, startParameter.getLockedDependenciesToUpdate());
            encoder.writeBoolean(startParameter.isBuildProjectDependencies());
            encoder.writeBoolean(startParameter.isDryRun());
            encoder.writeBoolean(startParameter.isRerunTasks());
            encoder.writeBoolean(startParameter.isProfile());
            encoder.writeBoolean(startParameter.isContinueOnFailure());
            encoder.writeBoolean(startParameter.isOffline());
            encoder.writeBoolean(startParameter.isRefreshDependencies());
            encoder.writeBoolean(startParameter.isBuildCacheEnabled());
            encoder.writeBoolean(startParameter.isBuildCacheDebugLogging());
            encoder.writeString(startParameter.getWatchFileSystemMode().name());
            encoder.writeBoolean(startParameter.isWatchFileSystemDebugLogging());
            encoder.writeBoolean(startParameter.isVfsVerboseLogging());
            this.valueSerializer.write(encoder, startParameter.getConfigurationCache());
            this.valueSerializer.write(encoder, startParameter.getIsolatedProjects());
            encoder.writeString(startParameter.getConfigurationCacheProblems().name());
            encoder.writeBoolean(startParameter.isConfigurationCacheIgnoreInputsInTaskGraphSerialization());
            encoder.writeSmallInt(startParameter.getConfigurationCacheMaxProblems());
            encoder.writeNullableString(startParameter.getConfigurationCacheIgnoredFileSystemCheckInputs());
            encoder.writeBoolean(startParameter.isConfigurationCacheDebug());
            encoder.writeBoolean(startParameter.isConfigurationCacheRecreateCache());
            encoder.writeBoolean(startParameter.isConfigurationCacheQuiet());
            encoder.writeBoolean(startParameter.isConfigureOnDemand());
            encoder.writeBoolean(startParameter.isContinuous());
            encoder.writeLong(startParameter.getContinuousBuildQuietPeriod().toMillis());
            encoder.writeBoolean(startParameter.isBuildScan());
            encoder.writeBoolean(startParameter.isNoBuildScan());
            encoder.writeBoolean(startParameter.isWriteDependencyLocks());
            this.stringListSerializer.write(encoder, startParameter.getWriteDependencyVerifications());
            encoder.writeString(startParameter.getDependencyVerificationMode().name());
            encoder.writeBoolean(startParameter.isRefreshKeys());
            encoder.writeBoolean(startParameter.isExportKeys());
            encoder.writeString(startParameter.getWelcomeMessageConfiguration().getWelcomeMessageDisplayMode().name());
        }

        private void writeTaskRequests(Encoder encoder, List<TaskExecutionRequest> taskRequests) throws Exception {
            encoder.writeSmallInt(taskRequests.size());
            for (TaskExecutionRequest taskRequest : taskRequests) {
                if (taskRequest instanceof RunDefaultTasksExecutionRequest) {
                    encoder.writeByte((byte)0);
                    continue;
                }
                if (taskRequest instanceof DefaultTaskExecutionRequest) {
                    DefaultTaskExecutionRequest request = (DefaultTaskExecutionRequest)taskRequest;
                    encoder.writeByte((byte)1);
                    encoder.writeNullableString(request.getProjectPath());
                    this.nullableFileSerializer.write(encoder, request.getRootDir());
                    this.stringListSerializer.write(encoder, request.getArgs());
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public StartParameterInternal read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = new StartParameterInternal();
            startParameter.setLogLevel(this.logLevelSerializer.read(decoder));
            startParameter.setShowStacktrace(this.showStacktraceSerializer.read(decoder));
            startParameter.setConsoleOutput(this.consoleOutputSerializer.read(decoder));
            startParameter.setWarningMode(this.warningModeSerializer.read(decoder));
            startParameter.setParallelProjectExecutionEnabled(decoder.readBoolean());
            startParameter.setMaxWorkerCount(decoder.readSmallInt());
            startParameter.setTaskRequests(this.readTaskRequests(decoder));
            startParameter.setExcludedTaskNames((Iterable<String>)this.stringSetSerializer.read(decoder));
            DeprecationLogger.whileDisabledThrowing(() -> startParameter.setBuildFile(this.nullableFileSerializer.read(decoder)));
            startParameter.setProjectDir(this.nullableFileSerializer.read(decoder));
            DeprecationLogger.whileDisabledThrowing(() -> startParameter.setSettingsFile(this.nullableFileSerializer.read(decoder)));
            startParameter.setCurrentDir(BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleUserHomeDir(BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleHomeDir(this.nullableFileSerializer.read(decoder));
            startParameter.setProjectCacheDir(this.nullableFileSerializer.read(decoder));
            startParameter.setIncludedBuilds(this.fileListSerializer.read(decoder));
            startParameter.setProjectProperties(BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setSystemPropertiesArgs(BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setInitScripts(this.fileListSerializer.read(decoder));
            startParameter.setLockedDependenciesToUpdate(this.stringListSerializer.read(decoder));
            startParameter.setBuildProjectDependencies(decoder.readBoolean());
            startParameter.setDryRun(decoder.readBoolean());
            startParameter.setRerunTasks(decoder.readBoolean());
            startParameter.setProfile(decoder.readBoolean());
            startParameter.setContinueOnFailure(decoder.readBoolean());
            startParameter.setOffline(decoder.readBoolean());
            startParameter.setRefreshDependencies(decoder.readBoolean());
            startParameter.setBuildCacheEnabled(decoder.readBoolean());
            startParameter.setBuildCacheDebugLogging(decoder.readBoolean());
            startParameter.setWatchFileSystemMode(WatchMode.valueOf(decoder.readString()));
            startParameter.setWatchFileSystemDebugLogging(decoder.readBoolean());
            startParameter.setVfsVerboseLogging(decoder.readBoolean());
            startParameter.setConfigurationCache(this.valueSerializer.read(decoder));
            startParameter.setIsolatedProjects(this.valueSerializer.read(decoder));
            startParameter.setConfigurationCacheProblems(StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value.valueOf(decoder.readString()));
            startParameter.setConfigurationCacheIgnoreInputsInTaskGraphSerialization(decoder.readBoolean());
            startParameter.setConfigurationCacheMaxProblems(decoder.readSmallInt());
            startParameter.setConfigurationCacheIgnoredFileSystemCheckInputs(decoder.readNullableString());
            startParameter.setConfigurationCacheDebug(decoder.readBoolean());
            startParameter.setConfigurationCacheRecreateCache(decoder.readBoolean());
            startParameter.setConfigurationCacheQuiet(decoder.readBoolean());
            startParameter.setConfigureOnDemand(decoder.readBoolean());
            startParameter.setContinuous(decoder.readBoolean());
            startParameter.setContinuousBuildQuietPeriod(Duration.ofMillis(decoder.readLong()));
            startParameter.setBuildScan(decoder.readBoolean());
            startParameter.setNoBuildScan(decoder.readBoolean());
            startParameter.setWriteDependencyLocks(decoder.readBoolean());
            List<String> checksums = this.stringListSerializer.read(decoder);
            if (!checksums.isEmpty()) {
                startParameter.setWriteDependencyVerifications(checksums);
            }
            startParameter.setDependencyVerificationMode(DependencyVerificationMode.valueOf(decoder.readString()));
            startParameter.setRefreshKeys(decoder.readBoolean());
            startParameter.setExportKeys(decoder.readBoolean());
            startParameter.setWelcomeMessageConfiguration(new WelcomeMessageConfiguration(WelcomeMessageDisplayMode.valueOf(decoder.readString())));
            return startParameter;
        }

        private List<TaskExecutionRequest> readTaskRequests(Decoder decoder) throws Exception {
            int requestCount = decoder.readSmallInt();
            ArrayList<TaskExecutionRequest> taskExecutionRequests = new ArrayList<TaskExecutionRequest>(requestCount);
            for (int i = 0; i < requestCount; ++i) {
                byte tag = decoder.readByte();
                if (tag == 0) {
                    taskExecutionRequests.add(new RunDefaultTasksExecutionRequest());
                    continue;
                }
                if (tag == 1) {
                    String projectPath = decoder.readNullableString();
                    File rootDir = this.nullableFileSerializer.read(decoder);
                    List<String> args = this.stringListSerializer.read(decoder);
                    taskExecutionRequests.add(new DefaultTaskExecutionRequest(args, projectPath, rootDir));
                    continue;
                }
                throw new IllegalStateException();
            }
            return taskExecutionRequests;
        }
    }
}

