/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ExternalProcessStartedListener;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.DefaultFileLookup;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.model.InstantiatorBackedObjectFactory;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultExecAction;
import org.gradle.process.internal.DefaultExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.process.internal.DefaultJavaExecAction;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecFactory;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaForkOptionsInternal;

public abstract class DefaultExecActionFactory
implements ExecFactory {
    protected final FileResolver fileResolver;
    protected final Executor executor;
    protected final FileCollectionFactory fileCollectionFactory;
    protected final ObjectFactory objectFactory;
    protected final TemporaryFileProvider temporaryFileProvider;
    @Nullable
    protected final JavaModuleDetector javaModuleDetector;
    protected final BuildCancellationToken buildCancellationToken;

    private DefaultExecActionFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, Executor executor, TemporaryFileProvider temporaryFileProvider, @Nullable JavaModuleDetector javaModuleDetector, BuildCancellationToken buildCancellationToken) {
        this.fileResolver = fileResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.objectFactory = objectFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.javaModuleDetector = javaModuleDetector;
        this.buildCancellationToken = buildCancellationToken;
        this.executor = executor;
    }

    @Deprecated
    public static DefaultExecActionFactory root(File gradleUserHome) {
        Objects.requireNonNull(gradleUserHome, "gradleUserHome");
        Factory<PatternSet> patternSetFactory = PatternSets.getNonCachingPatternSetFactory();
        FileResolver resolver = new DefaultFileLookup().getFileResolver();
        DefaultFileCollectionFactory fileCollectionFactory = new DefaultFileCollectionFactory(resolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), patternSetFactory, PropertyHost.NO_OP, FileSystems.getDefault());
        GradleUserHomeDirProvider userHomeDirProvider = () -> gradleUserHome;
        GradleUserHomeTemporaryFileProvider temporaryFileProvider = new GradleUserHomeTemporaryFileProvider(userHomeDirProvider);
        return DefaultExecActionFactory.of(resolver, fileCollectionFactory, new InstantiatorBackedObjectFactory(DirectInstantiator.INSTANCE), new DefaultExecutorFactory(), new DefaultBuildCancellationToken(), temporaryFileProvider);
    }

    public static DefaultExecActionFactory of(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ExecutorFactory executorFactory, TemporaryFileProvider temporaryFileProvider) {
        return DefaultExecActionFactory.of(fileResolver, fileCollectionFactory, new InstantiatorBackedObjectFactory(DirectInstantiator.INSTANCE), executorFactory, new DefaultBuildCancellationToken(), temporaryFileProvider);
    }

    private static DefaultExecActionFactory of(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, ExecutorFactory executorFactory, BuildCancellationToken buildCancellationToken, TemporaryFileProvider temporaryFileProvider) {
        return new RootExecFactory(fileResolver, fileCollectionFactory, objectFactory, executorFactory, buildCancellationToken, temporaryFileProvider);
    }

    @Override
    public ExecFactory.Builder forContext() {
        return new BuilderImpl(this.executor, this.temporaryFileProvider).withFileResolver(this.fileResolver).withFileCollectionFactory(this.fileCollectionFactory).withBuildCancellationToken(this.buildCancellationToken).withObjectFactory(this.objectFactory).withJavaModuleDetector(this.javaModuleDetector);
    }

    public ExecAction newDecoratedExecAction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecAction newExecAction() {
        return new DefaultExecAction(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    @Override
    public JavaForkOptionsInternal newDecoratedJavaForkOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaForkOptionsInternal newJavaForkOptions() {
        DefaultJavaForkOptions forkOptions = new DefaultJavaForkOptions(this.fileResolver, this.fileCollectionFactory, new DefaultJavaDebugOptions());
        if (forkOptions.getExecutable() == null) {
            forkOptions.setExecutable(Jvm.current().getJavaExecutable());
        }
        return forkOptions;
    }

    @Override
    public JavaForkOptionsInternal immutableCopy(JavaForkOptionsInternal options) {
        Factory<PatternSet> nonCachingPatternSetFactory = PatternSets.getNonCachingPatternSetFactory();
        DefaultFileCollectionFactory fileCollectionFactory = new DefaultFileCollectionFactory(this.fileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), nonCachingPatternSetFactory, PropertyHost.NO_OP, FileSystems.getDefault());
        DefaultJavaForkOptions copy = new DefaultJavaForkOptions(this.fileResolver, fileCollectionFactory, new DefaultJavaDebugOptions());
        options.copyTo(copy);
        return new ImmutableJavaForkOptions(copy);
    }

    public JavaExecAction newDecoratedJavaExecAction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaExecAction newJavaExecAction() {
        return new DefaultJavaExecAction(this.fileResolver, this.fileCollectionFactory, this.objectFactory, this.executor, this.buildCancellationToken, this.temporaryFileProvider, this.javaModuleDetector, this.newJavaForkOptions());
    }

    @Override
    public ExecHandleBuilder newExec() {
        return new DefaultExecHandleBuilder(this.fileResolver, this.executor, this.buildCancellationToken);
    }

    @Override
    public JavaExecHandleBuilder newJavaExec() {
        return new JavaExecHandleBuilder(this.fileResolver, this.fileCollectionFactory, this.objectFactory, this.executor, this.buildCancellationToken, this.temporaryFileProvider, this.javaModuleDetector, this.newJavaForkOptions());
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        JavaExecAction execAction = this.newDecoratedJavaExecAction();
        action.execute(execAction);
        return execAction.execute();
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        ExecAction execAction = this.newDecoratedExecAction();
        action.execute(execAction);
        return execAction.execute();
    }

    private static class ImmutableJavaForkOptions
    implements JavaForkOptionsInternal {
        private final JavaForkOptionsInternal delegate;

        public ImmutableJavaForkOptions(JavaForkOptionsInternal delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getExecutable() {
            return this.delegate.getExecutable();
        }

        @Override
        public void setExecutable(String executable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getSystemProperties() {
            return ImmutableMap.copyOf(this.delegate.getSystemProperties());
        }

        @Override
        public void setExecutable(Object executable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSystemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessForkOptions executable(Object executable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions systemProperties(Map<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public File getWorkingDir() {
            return this.delegate.getWorkingDir();
        }

        @Override
        public void setWorkingDir(File dir) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions systemProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWorkingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDefaultCharacterEncoding() {
            return this.delegate.getDefaultCharacterEncoding();
        }

        @Override
        public ProcessForkOptions workingDir(Object dir) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getEnvironment() {
            return ImmutableMap.copyOf(this.delegate.getEnvironment());
        }

        @Override
        public void setEnvironment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMinHeapSize() {
            return this.delegate.getMinHeapSize();
        }

        @Override
        public void setMinHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessForkOptions environment(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessForkOptions copyTo(ProcessForkOptions options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMaxHeapSize() {
            return this.delegate.getMaxHeapSize();
        }

        @Override
        public void setMaxHeapSize(String heapSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getJvmArgs() {
            return ImmutableList.copyOf(this.delegate.getJvmArgs());
        }

        @Override
        public void setJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions jvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions jvmArgs(Object ... arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileCollection getBootstrapClasspath() {
            return this.delegate.getBootstrapClasspath();
        }

        @Override
        public void setBootstrapClasspath(FileCollection classpath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions bootstrapClasspath(Object ... classpath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getEnableAssertions() {
            return this.delegate.getEnableAssertions();
        }

        @Override
        public void setEnableAssertions(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDebug() {
            return this.delegate.getDebug();
        }

        @Override
        public void setDebug(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaDebugOptions getDebugOptions() {
            return this.delegate.getDebugOptions();
        }

        @Override
        public void debugOptions(Action<JavaDebugOptions> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllJvmArgs() {
            return ImmutableList.copyOf(this.delegate.getAllJvmArgs());
        }

        @Override
        public void setAllJvmArgs(List<String> arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAllJvmArgs(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaForkOptions copyTo(JavaForkOptions options) {
            return this.delegate.copyTo(options);
        }

        @Override
        public boolean isCompatibleWith(JavaForkOptions options) {
            return this.delegate.isCompatibleWith(options);
        }

        @Override
        public void setExtraJvmArgs(Iterable<?> jvmArgs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkDebugConfiguration(Iterable<?> arguments) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DecoratingExecActionFactory
    extends DefaultExecActionFactory {
        private final Instantiator instantiator;
        @Nullable
        private final ExternalProcessStartedListener externalProcessStartedListener;

        DecoratingExecActionFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Instantiator instantiator2, Executor executor, TemporaryFileProvider temporaryFileProvider, BuildCancellationToken buildCancellationToken, ObjectFactory objectFactory, @Nullable JavaModuleDetector javaModuleDetector, @Nullable ExternalProcessStartedListener externalProcessStartedListener) {
            super(fileResolver, fileCollectionFactory, objectFactory, executor, temporaryFileProvider, javaModuleDetector, buildCancellationToken);
            this.instantiator = instantiator2;
            this.externalProcessStartedListener = externalProcessStartedListener;
        }

        @Override
        public ExecAction newDecoratedExecAction() {
            DefaultExecAction execAction = this.instantiator.newInstance(DefaultExecAction.class, this.fileResolver, this.executor, this.buildCancellationToken);
            ExecHandleListener listener2 = this.getExecHandleListener();
            if (listener2 != null) {
                execAction.listener(listener2);
            }
            return execAction;
        }

        @Override
        public JavaExecAction newDecoratedJavaExecAction() {
            JavaForkOptionsInternal forkOptions = this.newDecoratedJavaForkOptions();
            forkOptions.setExecutable(Jvm.current().getJavaExecutable());
            DefaultJavaExecAction javaExecAction = this.instantiator.newInstance(DefaultJavaExecAction.class, this.fileResolver, this.fileCollectionFactory, this.objectFactory, this.executor, this.buildCancellationToken, this.temporaryFileProvider, this.javaModuleDetector, forkOptions);
            ExecHandleListener listener2 = this.getExecHandleListener();
            if (listener2 != null) {
                javaExecAction.listener(listener2);
            }
            return javaExecAction;
        }

        @Override
        public JavaForkOptionsInternal newDecoratedJavaForkOptions() {
            JavaDebugOptions javaDebugOptions = this.objectFactory.newInstance(DefaultJavaDebugOptions.class, this.objectFactory);
            DefaultJavaForkOptions forkOptions = this.instantiator.newInstance(DefaultJavaForkOptions.class, this.fileResolver, this.fileCollectionFactory, javaDebugOptions);
            forkOptions.setExecutable(Jvm.current().getJavaExecutable());
            return forkOptions;
        }

        @Override
        public ExecFactory.Builder forContext() {
            return super.forContext().withInstantiator(this.instantiator).withExternalProcessStartedListener(this.externalProcessStartedListener);
        }

        @Nullable
        private ExecHandleListener getExecHandleListener() {
            if (this.externalProcessStartedListener == null) {
                return null;
            }
            return new ExecHandleListener(){

                @Override
                public void beforeExecutionStarted(ExecHandle execHandle) {
                    StringBuilder command = new StringBuilder(execHandle.getCommand());
                    for (String argument : execHandle.getArguments()) {
                        command.append(' ').append(argument);
                    }
                    externalProcessStartedListener.onExternalProcessStarted(command.toString(), null);
                }

                @Override
                public void executionStarted(ExecHandle execHandle) {
                }

                @Override
                public void executionFinished(ExecHandle execHandle, ExecResult execResult) {
                }
            };
        }
    }

    private static class RootExecFactory
    extends DefaultExecActionFactory
    implements Stoppable {
        public RootExecFactory(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, ExecutorFactory executorFactory, BuildCancellationToken buildCancellationToken, TemporaryFileProvider temporaryFileProvider) {
            super(fileResolver, fileCollectionFactory, objectFactory, executorFactory.create("Exec process"), temporaryFileProvider, null, buildCancellationToken);
        }

        @Override
        public void stop() {
            CompositeStoppable.stoppable(this.executor).stop();
        }
    }

    private static class BuilderImpl
    implements ExecFactory.Builder {
        private final Executor executor;
        private final TemporaryFileProvider temporaryFileProvider;
        private FileResolver fileResolver;
        private FileCollectionFactory fileCollectionFactory;
        private Instantiator instantiator;
        private BuildCancellationToken buildCancellationToken;
        private ObjectFactory objectFactory;
        @Nullable
        private JavaModuleDetector javaModuleDetector;
        @Nullable
        private ExternalProcessStartedListener externalProcessStartedListener;

        BuilderImpl(Executor executor, TemporaryFileProvider temporaryFileProvider) {
            this.executor = executor;
            this.temporaryFileProvider = temporaryFileProvider;
        }

        @Override
        public ExecFactory.Builder withFileResolver(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
            return this;
        }

        @Override
        public ExecFactory.Builder withFileCollectionFactory(FileCollectionFactory fileCollectionFactory) {
            this.fileCollectionFactory = fileCollectionFactory;
            return this;
        }

        @Override
        public ExecFactory.Builder withInstantiator(Instantiator instantiator2) {
            this.instantiator = instantiator2;
            return this;
        }

        @Override
        public ExecFactory.Builder withObjectFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        @Override
        public ExecFactory.Builder withJavaModuleDetector(@Nullable JavaModuleDetector javaModuleDetector) {
            this.javaModuleDetector = javaModuleDetector;
            return this;
        }

        @Override
        public ExecFactory.Builder withBuildCancellationToken(BuildCancellationToken buildCancellationToken) {
            this.buildCancellationToken = buildCancellationToken;
            return this;
        }

        @Override
        public ExecFactory.Builder withExternalProcessStartedListener(@Nullable ExternalProcessStartedListener externalProcessStartedListener) {
            this.externalProcessStartedListener = externalProcessStartedListener;
            return this;
        }

        @Override
        public ExecFactory.Builder withoutExternalProcessStartedListener() {
            this.externalProcessStartedListener = null;
            return this;
        }

        @Override
        public ExecFactory build() {
            Preconditions.checkState((this.fileResolver != null ? 1 : 0) != 0, (Object)"fileResolver is not set");
            Preconditions.checkState((this.fileCollectionFactory != null ? 1 : 0) != 0, (Object)"fileCollectionFactory is not set");
            Preconditions.checkState((this.instantiator != null ? 1 : 0) != 0, (Object)"instantiator is not set");
            Preconditions.checkState((this.buildCancellationToken != null ? 1 : 0) != 0, (Object)"buildCancellationToken is not set");
            Preconditions.checkState((this.objectFactory != null ? 1 : 0) != 0, (Object)"objectFactory is not set");
            return new DecoratingExecActionFactory(this.fileResolver, this.fileCollectionFactory, this.instantiator, this.executor, this.temporaryFileProvider, this.buildCancellationToken, this.objectFactory, this.javaModuleDetector, this.externalProcessStartedListener);
        }
    }
}

