/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.specs.Spec;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;

public class DefaultIdeDependencyResolver {
    private static final Spec<ComponentIdentifier> IS_A_MODULE_ID = new Spec<ComponentIdentifier>(){

        @Override
        public boolean isSatisfiedBy(ComponentIdentifier id) {
            return id instanceof ModuleComponentIdentifier;
        }
    };

    public List<IdeExtendedRepoFileDependency> getIdeRepoFileDependencies(Configuration configuration) {
        Set<ResolvedArtifactResult> artifacts2 = configuration.getIncoming().artifactView((Action<? super ArtifactView.ViewConfiguration>)new Action<ArtifactView.ViewConfiguration>(){

            @Override
            public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                viewConfiguration.lenient(true);
                viewConfiguration.componentFilter(IS_A_MODULE_ID);
            }
        }).getArtifacts().getArtifacts();
        ArrayList<IdeExtendedRepoFileDependency> externalDependencies = new ArrayList<IdeExtendedRepoFileDependency>(artifacts2.size());
        for (ResolvedArtifactResult artifact : artifacts2) {
            ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)artifact.getId().getComponentIdentifier();
            IdeExtendedRepoFileDependency ideRepoFileDependency = new IdeExtendedRepoFileDependency();
            ideRepoFileDependency.setId(DefaultModuleVersionIdentifier.newId(moduleId.getModuleIdentifier(), moduleId.getVersion()));
            externalDependencies.add(ideRepoFileDependency);
        }
        return externalDependencies;
    }
}

