/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LegacyWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.platform.base.internal.toolchain.SearchResult;

public class DefaultWindowsSdkLocator
implements WindowsSdkLocator {
    private final WindowsSdkLocator legacyWindowsSdkLocator;
    private final WindowsComponentLocator<WindowsKitSdkInstall> windowsKitWindowsSdkLocator;

    @VisibleForTesting
    DefaultWindowsSdkLocator(WindowsSdkLocator legacyWindowsSdkLocator, WindowsComponentLocator<WindowsKitSdkInstall> windowsKitWindowsSdkLocator) {
        this.legacyWindowsSdkLocator = legacyWindowsSdkLocator;
        this.windowsKitWindowsSdkLocator = windowsKitWindowsSdkLocator;
    }

    public DefaultWindowsSdkLocator(OperatingSystem operatingSystem, WindowsRegistry windowsRegistry, SystemInfo systemInfo) {
        this(new LegacyWindowsSdkLocator(operatingSystem, windowsRegistry), new WindowsKitWindowsSdkLocator(windowsRegistry, systemInfo));
    }

    @Override
    public SearchResult<WindowsSdkInstall> locateComponent(@Nullable File candidate) {
        return new SdkSearchResult(this.legacyWindowsSdkLocator.locateComponent(candidate), this.windowsKitWindowsSdkLocator.locateComponent(candidate));
    }

    @Override
    public List<WindowsSdkInstall> locateAllComponents() {
        ArrayList allSdks = Lists.newArrayList();
        allSdks.addAll(this.legacyWindowsSdkLocator.locateAllComponents());
        allSdks.addAll(this.windowsKitWindowsSdkLocator.locateAllComponents());
        return allSdks;
    }

    private static class SdkSearchResult
    implements SearchResult<WindowsSdkInstall> {
        final SearchResult<WindowsSdkInstall> legacySearchResult;
        final SearchResult<WindowsKitSdkInstall> windowsKitSearchResult;

        SdkSearchResult(SearchResult<WindowsSdkInstall> legacySearchResult, SearchResult<WindowsKitSdkInstall> windowsKitSearchResult) {
            this.legacySearchResult = legacySearchResult;
            this.windowsKitSearchResult = windowsKitSearchResult;
        }

        @Override
        public WindowsSdkInstall getComponent() {
            if (this.windowsKitSearchResult.isAvailable()) {
                return this.windowsKitSearchResult.getComponent();
            }
            if (this.legacySearchResult.isAvailable()) {
                return this.legacySearchResult.getComponent();
            }
            return null;
        }

        @Override
        public boolean isAvailable() {
            return this.windowsKitSearchResult.isAvailable() || this.legacySearchResult.isAvailable();
        }

        @Override
        public void explain(DiagnosticsVisitor visitor) {
            this.windowsKitSearchResult.explain(visitor);
        }
    }
}

