/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineBuilder;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.internal.DefaultTargetMachine;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public class DefaultTargetMachineFactory
implements TargetMachineFactory {
    private final ObjectFactory objectFactory;

    public DefaultTargetMachineFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public TargetMachine host() {
        DefaultNativePlatform host = DefaultNativePlatform.host();
        OperatingSystemFamily operatingSystemFamily = this.objectFactory.named(OperatingSystemFamily.class, host.getOperatingSystem().toFamilyName());
        MachineArchitecture machineArchitecture = this.objectFactory.named(MachineArchitecture.class, host.getArchitecture().getName());
        return new TargetMachineImpl(operatingSystemFamily, machineArchitecture);
    }

    @Override
    public TargetMachineBuilder getWindows() {
        return new TargetMachineImpl(this.objectFactory.named(OperatingSystemFamily.class, "windows"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachineBuilder getLinux() {
        return new TargetMachineImpl(this.objectFactory.named(OperatingSystemFamily.class, "linux"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachineBuilder getMacOS() {
        return new TargetMachineImpl(this.objectFactory.named(OperatingSystemFamily.class, "macos"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachineBuilder os(String operatingSystemFamily) {
        return new TargetMachineImpl(this.objectFactory.named(OperatingSystemFamily.class, operatingSystemFamily), this.getDefaultArchitecture());
    }

    private MachineArchitecture getDefaultArchitecture() {
        return this.objectFactory.named(MachineArchitecture.class, DefaultNativePlatform.host().getArchitecture().getName());
    }

    private class TargetMachineImpl
    extends DefaultTargetMachine
    implements TargetMachineBuilder {
        public TargetMachineImpl(OperatingSystemFamily operatingSystemFamily, MachineArchitecture architecture) {
            super(operatingSystemFamily, architecture);
        }

        @Override
        public TargetMachine getX86() {
            return new TargetMachineImpl(this.getOperatingSystemFamily(), DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, "x86"));
        }

        @Override
        public TargetMachine getX86_64() {
            return new TargetMachineImpl(this.getOperatingSystemFamily(), DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, "x86-64"));
        }

        @Override
        public TargetMachine architecture(String architecture) {
            return new TargetMachineImpl(this.getOperatingSystemFamily(), DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, architecture));
        }
    }
}

