/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.nativeplatform.internal.CompileTaskConfig;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.language.nativeplatform.internal.NativeLanguageTransform;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.nativeplatform.tasks.AbstractNativeSourceCompileTask;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

public class SourceCompileTaskConfig
extends CompileTaskConfig {
    public SourceCompileTaskConfig(NativeLanguageTransform<?> languageTransform, Class<? extends DefaultTask> taskType) {
        super(languageTransform, taskType);
    }

    @Override
    protected void configureCompileTask(AbstractNativeCompileTask abstractTask, NativeBinarySpecInternal binary, LanguageSourceSetInternal sourceSet) {
        AbstractNativeSourceCompileTask task = (AbstractNativeSourceCompileTask)abstractTask;
        task.setDescription("Compiles the " + sourceSet + " of " + binary);
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.getObjectFileDir().fileProvider((Provider)project.getLayout().getBuildDirectory().getAsFile().map(it -> new File(binary.getNamingScheme().getOutputDirectory((File)it, "objs"), sourceSet.getProjectScopedName())));
        if (sourceSet instanceof DependentSourceSetInternal && ((DependentSourceSetInternal)((Object)sourceSet)).getPreCompiledHeader() != null) {
            DependentSourceSetInternal dependentSourceSet = (DependentSourceSetInternal)((Object)sourceSet);
            PreCompiledHeader pch = binary.getPrefixFileToPCH().get(dependentSourceSet.getPrefixHeaderFile());
            pch.setPrefixHeaderFile(dependentSourceSet.getPrefixHeaderFile());
            pch.setIncludeString(dependentSourceSet.getPreCompiledHeader());
            task.setPreCompiledHeader(pch);
        }
        binary.binaryInputs(task.getOutputs().getFiles().getAsFileTree().matching(new PatternSet().include("**/*.obj", "**/*.o")));
    }
}

