/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.net.URI;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpATTRS;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpException;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpResource;

public class SftpResourceAccessor
extends AbstractExternalResourceAccessor
implements ExternalResourceAccessor {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceAccessor(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    @Override
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        LockableSftpClient sftpClient = this.sftpClientFactory.createSftpClient(location.getUri(), this.credentials);
        try {
            SftpATTRS attributes = sftpClient.getSftpClient().lstat(location.getPath());
            ExternalResourceMetaData externalResourceMetaData = attributes != null ? this.toMetaData(location.getUri(), attributes) : null;
            return externalResourceMetaData;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                ExternalResourceMetaData externalResourceMetaData = null;
                return externalResourceMetaData;
            }
            throw ResourceExceptions.getFailed(location.getUri(), e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(sftpClient);
        }
    }

    private ExternalResourceMetaData toMetaData(URI uri, SftpATTRS attributes) {
        long lastModified = -1L;
        long contentLength = -1L;
        if ((attributes.getFlags() & 8) != 0) {
            lastModified = (long)attributes.getMTime() * 1000L;
        }
        if ((attributes.getFlags() & 1) != 0) {
            contentLength = attributes.getSize();
        }
        return new DefaultExternalResourceMetaData(uri, lastModified, contentLength);
    }

    @Override
    public ExternalResourceReadResponse openResource(ExternalResourceName location, boolean revalidate) {
        ExternalResourceMetaData metaData = this.getMetaData(location, revalidate);
        return metaData != null ? new SftpResource(this.sftpClientFactory, metaData, location.getUri(), this.credentials) : null;
    }
}

