/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import java.util.List;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public class DefaultComponentArtifactResolver
implements ComponentArtifactResolver {
    private final ComponentArtifactResolveMetadata component;
    private final ArtifactResolver artifactResolver;

    public DefaultComponentArtifactResolver(ComponentArtifactResolveMetadata component, ArtifactResolver artifactResolver) {
        this.component = component;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public Set<ResolvableArtifact> resolveArtifacts(List<? extends ComponentArtifactMetadata> artifacts2) {
        ImmutableSet.Builder resolvedArtifacts = ImmutableSet.builder();
        for (ComponentArtifactMetadata componentArtifactMetadata : artifacts2) {
            DefaultBuildableArtifactResolveResult result2 = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.component, componentArtifactMetadata, result2);
            if (componentArtifactMetadata.isOptionalArtifact()) {
                try {
                    ((ResolvableArtifact)result2.getResult()).getFile();
                }
                catch (Exception e) {
                    continue;
                }
            }
            resolvedArtifacts.add((Object)((ResolvableArtifact)result2.getResult()));
        }
        return resolvedArtifacts.build();
    }
}

