/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class ReplayingTypeValidationContext
implements TypeValidationContext {
    private final List<BiConsumer<String, TypeValidationContext>> problems = new ArrayList<BiConsumer<String, TypeValidationContext>>();

    @Override
    public void visitTypeProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        this.problems.add((ownerProperty, validationContext) -> validationContext.visitTypeProblem(problemSpec));
    }

    @Override
    public void visitPropertyProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        this.problems.add((ownerProperty, validationContext) -> validationContext.visitPropertyProblem(builder -> {
            problemSpec.execute((TypeAwareProblemBuilder)builder);
            builder.parentProperty((String)ownerProperty);
        }));
    }

    public void replay(@Nullable String ownerProperty, TypeValidationContext target) {
        this.problems.forEach(problem2 -> problem2.accept(ownerProperty, target));
    }
}

