/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.execution.history.changes.AbstractFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;

public class ClasspathCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new ClasspathCompareStrategy();

    private ClasspathCompareStrategy() {
        super(ClasspathCompareStrategy::visitChangesSince);
    }

    private static boolean visitChangesSince(Map<String, FileSystemLocationFingerprint> previousFingerprints, Map<String, FileSystemLocationFingerprint> currentFingerprints, String propertyTitle, ChangeVisitor visitor) {
        TrackingVisitor trackingVisitor = new TrackingVisitor(visitor);
        ChangeState changeState = new ChangeState(propertyTitle, trackingVisitor, currentFingerprints, previousFingerprints);
        while (trackingVisitor.isConsumeMore() && changeState.hasMoreToProcess()) {
            changeState.processChange();
        }
        return trackingVisitor.isConsumeMore();
    }

    private static class ChangeState {
        private Map.Entry<String, FileSystemLocationFingerprint> current;
        private Map.Entry<String, FileSystemLocationFingerprint> previous;
        private final ChangeVisitor changeConsumer;
        private final Iterator<Map.Entry<String, FileSystemLocationFingerprint>> currentEntries;
        private final Map<String, FileSystemLocationFingerprint> currentSnapshots;
        private final Iterator<Map.Entry<String, FileSystemLocationFingerprint>> previousEntries;
        private final Map<String, FileSystemLocationFingerprint> previousSnapshots;
        private final String propertyTitle;

        private ChangeState(String propertyTitle, ChangeVisitor changeConsumer, Map<String, FileSystemLocationFingerprint> currentSnapshots, Map<String, FileSystemLocationFingerprint> previousSnapshots) {
            this.propertyTitle = propertyTitle;
            this.changeConsumer = changeConsumer;
            this.currentEntries = currentSnapshots.entrySet().iterator();
            this.currentSnapshots = currentSnapshots;
            this.previousEntries = previousSnapshots.entrySet().iterator();
            this.previousSnapshots = previousSnapshots;
            this.current = this.nextEntry(this.currentEntries);
            this.previous = this.nextEntry(this.previousEntries);
        }

        void processChange() {
            if (this.current == null) {
                if (this.previous != null) {
                    this.removed();
                }
            } else if (this.previous == null) {
                this.added();
            } else {
                String previousNormalizedPath;
                FileSystemLocationFingerprint currentFingerprint = this.current.getValue();
                FileSystemLocationFingerprint previousFingerprint = this.previous.getValue();
                String currentNormalizedPath = currentFingerprint.getNormalizedPath();
                if (!currentNormalizedPath.equals(previousNormalizedPath = previousFingerprint.getNormalizedPath())) {
                    this.removed();
                    this.added();
                } else if (currentFingerprint.getNormalizedContentHash().equals(previousFingerprint.getNormalizedContentHash())) {
                    this.current = this.nextEntry(this.currentEntries);
                    this.previous = this.nextEntry(this.previousEntries);
                } else if (currentNormalizedPath.isEmpty()) {
                    String previousAbsolutePath;
                    String currentAbsolutePath = this.current.getKey();
                    if (!currentAbsolutePath.equals(previousAbsolutePath = this.previous.getKey())) {
                        if (!this.currentSnapshots.containsKey(previousAbsolutePath)) {
                            this.removed();
                        } else if (!this.previousSnapshots.containsKey(currentAbsolutePath)) {
                            this.added();
                        } else {
                            this.removed();
                            this.added();
                        }
                    } else {
                        this.modified();
                    }
                } else {
                    this.modified();
                }
            }
        }

        void added() {
            DefaultFileChange added = DefaultFileChange.added(this.current.getKey(), this.propertyTitle, this.current.getValue().getType(), this.current.getValue().getNormalizedPath());
            this.changeConsumer.visitChange(added);
            this.current = this.nextEntry(this.currentEntries);
        }

        void removed() {
            DefaultFileChange removed = DefaultFileChange.removed(this.previous.getKey(), this.propertyTitle, this.previous.getValue().getType(), this.previous.getValue().getNormalizedPath());
            this.changeConsumer.visitChange(removed);
            this.previous = this.nextEntry(this.previousEntries);
        }

        void modified() {
            DefaultFileChange modified = DefaultFileChange.modified(this.current.getKey(), this.propertyTitle, this.previous.getValue().getType(), this.current.getValue().getType(), this.current.getValue().getNormalizedPath());
            this.changeConsumer.visitChange(modified);
            this.previous = this.nextEntry(this.previousEntries);
            this.current = this.nextEntry(this.currentEntries);
        }

        @Nullable
        private <T> T nextEntry(Iterator<T> iterator) {
            return iterator.hasNext() ? (T)iterator.next() : null;
        }

        public boolean hasMoreToProcess() {
            return this.current != null || this.previous != null;
        }
    }

    private static class TrackingVisitor
    implements ChangeVisitor {
        private final ChangeVisitor visitor;
        private boolean consumeMore = true;

        private TrackingVisitor(ChangeVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public boolean visitChange(Change change) {
            if (this.consumeMore) {
                this.consumeMore = this.visitor.visitChange(change);
            }
            return this.consumeMore;
        }

        public boolean isConsumeMore() {
            return this.consumeMore;
        }
    }
}

