/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlagListener;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.buildoption.InternalFlag;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.Option;
import org.gradle.internal.event.ListenerManager;

public class DefaultFeatureFlags
implements FeatureFlags {
    private final Set<FeatureFlag> enabled = new CopyOnWriteArraySet<FeatureFlag>();
    private final InternalOptions options;
    private final FeatureFlagListener broadcaster;

    public DefaultFeatureFlags(InternalOptions options, ListenerManager listenerManager) {
        this.options = options;
        this.broadcaster = listenerManager.getBroadcaster(FeatureFlagListener.class);
    }

    @Override
    public boolean isEnabled(FeatureFlag flag) {
        Option.Value<Boolean> option;
        this.broadcaster.flagRead(flag);
        if (flag.getSystemPropertyName() != null && ((option = this.options.getOption(new InternalFlag(flag.getSystemPropertyName()))).isExplicit() || option.get().booleanValue())) {
            return option.get();
        }
        return this.enabled.contains(flag);
    }

    @Override
    public void enable(FeatureFlag flag) {
        this.enabled.add(flag);
    }

    @Override
    public boolean isEnabledWithApi(FeatureFlag flag) {
        return this.enabled.contains(flag);
    }
}

