/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import org.gradle.api.internal.GradleInternal;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class BuildSourceBuilder {
    private static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    private final BuildState currentBuild;
    private final FileLockManager fileLockManager;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;
    private static final LockOptions LOCK_OPTIONS = LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive).useCrossVersionImplementation();

    public BuildSourceBuilder(BuildState currentBuild, FileLockManager fileLockManager, BuildOperationExecutor buildOperationExecutor, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath) {
        this.currentBuild = currentBuild;
        this.fileLockManager = fileLockManager;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
    }

    public ClassPath buildAndGetClassPath(GradleInternal gradle) {
        final StandAloneNestedBuild buildSrcBuild = this.buildRegistry.getBuildSrcNestedBuild(this.currentBuild);
        if (buildSrcBuild == null) {
            return ClassPath.EMPTY;
        }
        return this.buildOperationExecutor.call(new CallableBuildOperation<ClassPath>(){

            @Override
            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(buildSrcBuild);
                context.setResult(BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Build buildSrc").progressDisplayName("Building buildSrc").details(new BuildBuildSrcBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return BuildSourceBuilder.this.publicBuildPath.getBuildPath().toString();
                    }
                });
            }
        });
    }

    private ClassPath buildBuildSrc(StandAloneNestedBuild buildSrcBuild) {
        return buildSrcBuild.run(buildController -> {
            try (FileLock ignored = this.buildSrcBuildLockFor(buildSrcBuild);){
                ClassPath classPath = new BuildSrcUpdateFactory(this.buildSrcBuildListenerFactory).create((BuildTreeLifecycleController)buildController);
                return classPath;
            }
        });
    }

    private FileLock buildSrcBuildLockFor(StandAloneNestedBuild build2) {
        return this.fileLockManager.lock(new File(build2.getBuildRootDir(), ".gradle/noVersion/buildSrc"), LOCK_OPTIONS, "buildSrc build lock");
    }
}

