/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.BuildScopeListenerRegistrationListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.tasks.TaskState;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.ProjectExecutionServiceRegistry;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.taskgraph.NotifyTaskGraphWhenReadyBuildOperationType;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.InternalListener;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultTaskExecutionGraph
implements TaskExecutionGraphInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskExecutionGraph.class);
    private final PlanExecutor planExecutor;
    private final List<NodeExecutor> nodeExecutors;
    private final GradleInternal gradleInternal;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final BuildScopeListenerRegistrationListener buildScopeListenerRegistrationListener;
    private final ServiceRegistry globalServices;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ListenerBuildOperationDecorator listenerBuildOperationDecorator;
    private FinalizedExecutionPlan executionPlan;
    private List<Task> allTasks = Collections.emptyList();
    private boolean hasFiredWhenReady;

    public DefaultTaskExecutionGraph(PlanExecutor planExecutor, List<NodeExecutor> nodeExecutors, BuildOperationExecutor buildOperationExecutor, ListenerBuildOperationDecorator listenerBuildOperationDecorator, GradleInternal gradleInternal, ListenerBroadcast<TaskExecutionGraphListener> graphListeners, ListenerBroadcast<TaskExecutionListener> taskListeners, BuildScopeListenerRegistrationListener buildScopeListenerRegistrationListener, ServiceRegistry globalServices) {
        this.planExecutor = planExecutor;
        this.nodeExecutors = nodeExecutors;
        this.buildOperationExecutor = buildOperationExecutor;
        this.listenerBuildOperationDecorator = listenerBuildOperationDecorator;
        this.gradleInternal = gradleInternal;
        this.graphListeners = graphListeners;
        this.taskListeners = taskListeners;
        this.buildScopeListenerRegistrationListener = buildScopeListenerRegistrationListener;
        this.globalServices = globalServices;
        this.executionPlan = FinalizedExecutionPlan.EMPTY;
    }

    @Override
    public void populate(FinalizedExecutionPlan plan) {
        this.executionPlan.close();
        this.executionPlan = plan;
        this.allTasks = ImmutableList.copyOf(this.executionPlan.getContents().getTasks());
        if (!this.hasFiredWhenReady) {
            this.fireWhenReady();
            this.hasFiredWhenReady = true;
        } else if (!this.graphListeners.isEmpty()) {
            LOGGER.info("Ignoring listeners of task graph ready event, as this build ({}) has already executed work.", (Object)this.gradleInternal.getIdentityPath());
        }
    }

    @Override
    public ExecutionResult<Void> execute(FinalizedExecutionPlan plan) {
        this.assertIsThisGraphsPlan(plan);
        if (!this.hasFiredWhenReady) {
            throw new IllegalStateException("Task graph should be populated before execution starts.");
        }
        try {
            ProjectExecutionServiceRegistry projectExecutionServices = new ProjectExecutionServiceRegistry(this.globalServices);
            try {
                ExecutionResult<Void> executionResult2 = this.executeWithServices(projectExecutionServices);
                projectExecutionServices.close();
                return executionResult2;
            }
            catch (Throwable throwable) {
                try {
                    projectExecutionServices.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.executionPlan.close();
            this.executionPlan = FinalizedExecutionPlan.EMPTY;
        }
    }

    private void assertIsThisGraphsPlan(FinalizedExecutionPlan plan) {
        if (plan != this.executionPlan) {
            throw new IllegalArgumentException();
        }
    }

    private ExecutionResult<Void> executeWithServices(ProjectExecutionServiceRegistry projectExecutionServices) {
        return this.planExecutor.process(this.executionPlan.asWorkSource(), new BuildOperationAwareExecutionAction(this.buildOperationExecutor.getCurrentOperation(), new InvokeNodeExecutorsAction(this.nodeExecutors, projectExecutionServices)));
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener2) {
        this.graphListeners.add(this.decorateListener("TaskExecutionGraph.addTaskExecutionGraphListener", listener2));
    }

    private TaskExecutionGraphListener decorateListener(String registrationPoint, TaskExecutionGraphListener listener2) {
        return this.listenerBuildOperationDecorator.decorate(registrationPoint, TaskExecutionGraphListener.class, listener2);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener2) {
        this.graphListeners.remove(listener2);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add(new ClosureBackedMethodInvocationDispatch("graphPopulated", this.listenerBuildOperationDecorator.decorate("TaskExecutionGraph.whenReady", (Closure)Cast.uncheckedCast(closure))));
    }

    @Override
    public void whenReady(Action<TaskExecutionGraph> action) {
        this.graphListeners.add(this.decorateListener("TaskExecutionGraph.whenReady", action::execute));
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener2) {
        this.notifyListenerRegistration("TaskExecutionGraph.addTaskExecutionListener", listener2);
        this.taskListeners.add(listener2);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener2) {
        this.taskListeners.remove(listener2);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.notifyListenerRegistration("TaskExecutionGraph.beforeTask", closure);
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    @Override
    public void beforeTask(final Action<Task> action) {
        this.notifyListenerRegistration("TaskExecutionGraph.beforeTask", action);
        this.taskListeners.add(new TaskExecutionAdapter(){

            @Override
            public void beforeExecute(Task task) {
                action.execute(task);
            }
        });
    }

    @Override
    public void afterTask(Closure closure) {
        this.notifyListenerRegistration("TaskExecutionGraph.afterTask", closure);
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    @Override
    public void afterTask(final Action<Task> action) {
        this.notifyListenerRegistration("TaskExecutionGraph.afterTask", action);
        this.taskListeners.add(new TaskExecutionAdapter(){

            @Override
            public void afterExecute(Task task, TaskState state) {
                action.execute(task);
            }
        });
    }

    private void notifyListenerRegistration(String registrationPoint, Object listener2) {
        if (listener2 instanceof InternalListener) {
            return;
        }
        this.buildScopeListenerRegistrationListener.onBuildScopeListenerRegistration(listener2, registrationPoint, this);
    }

    @Override
    public boolean hasTask(Task task) {
        return this.executionPlan.getContents().getTasks().contains(task);
    }

    @Override
    @Nullable
    public Task findTask(String path) {
        for (Task task : this.executionPlan.getContents().getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return task;
        }
        return null;
    }

    @Override
    public boolean hasTask(String path) {
        return this.findTask(path) != null;
    }

    @Override
    public int size() {
        return this.executionPlan.getContents().size();
    }

    @Override
    public List<Task> getAllTasks() {
        return this.allTasks;
    }

    @Override
    public void visitScheduledNodes(Consumer<List<Node>> visitor) {
        this.executionPlan.getContents().getScheduledNodes().visitNodes(visitor);
    }

    @Override
    public Set<Task> getDependencies(Task task) {
        TaskNode node = this.executionPlan.getContents().getNode(task);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node dependencyNode : node.getDependencySuccessors()) {
            if (!(dependencyNode instanceof TaskNode)) continue;
            builder.add((Object)((TaskNode)dependencyNode).getTask());
        }
        return builder.build();
    }

    @Override
    public void resetState() {
        this.graphListeners.removeAll();
        this.taskListeners.removeAll();
        this.executionPlan.close();
        this.executionPlan = FinalizedExecutionPlan.EMPTY;
        this.allTasks = Collections.emptyList();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.executionPlan.getContents().getFilteredTasks();
    }

    private void fireWhenReady() {
        this.gradleInternal.getOwner().getProjects().withMutableStateOfAllProjects(() -> this.buildOperationExecutor.run(new NotifyTaskGraphWhenReady(this, this.graphListeners.getSource(), this.gradleInternal)));
    }

    private static class NotifyTaskGraphWhenReadyDetails
    implements NotifyTaskGraphWhenReadyBuildOperationType.Details {
        private final Path buildPath;

        NotifyTaskGraphWhenReadyDetails(Path buildPath) {
            this.buildPath = buildPath;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath.getPath();
        }
    }

    private static class NotifyTaskGraphWhenReady
    implements RunnableBuildOperation {
        private final TaskExecutionGraph taskExecutionGraph;
        private final TaskExecutionGraphListener graphListener;
        private final GradleInternal gradleInternal;

        private NotifyTaskGraphWhenReady(TaskExecutionGraph taskExecutionGraph, TaskExecutionGraphListener graphListener, GradleInternal gradleInternal) {
            this.taskExecutionGraph = taskExecutionGraph;
            this.graphListener = graphListener;
            this.gradleInternal = gradleInternal;
        }

        @Override
        public void run(BuildOperationContext context) {
            this.graphListener.graphPopulated(this.taskExecutionGraph);
            context.setResult(NotifyTaskGraphWhenReadyBuildOperationType.RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName(this.gradleInternal.contextualize("Notify task graph whenReady listeners")).details(new NotifyTaskGraphWhenReadyDetails(this.gradleInternal.getIdentityPath()));
        }
    }

    private static class InvokeNodeExecutorsAction
    implements Action<Node> {
        private final List<NodeExecutor> nodeExecutors;
        private final ProjectExecutionServiceRegistry projectExecutionServices;

        public InvokeNodeExecutorsAction(List<NodeExecutor> nodeExecutors, ProjectExecutionServiceRegistry projectExecutionServices) {
            this.nodeExecutors = nodeExecutors;
            this.projectExecutionServices = projectExecutionServices;
        }

        @Override
        public void execute(Node node) {
            NodeExecutionContext context = this.projectExecutionServices.forProject(node.getOwningProject());
            for (NodeExecutor nodeExecutor : this.nodeExecutors) {
                if (!nodeExecutor.execute(node, context)) continue;
                return;
            }
            throw new IllegalStateException("Unknown type of node: " + node);
        }
    }

    private static class BuildOperationAwareExecutionAction
    implements Action<Node> {
        private final BuildOperationRef parentOperation;
        private final Action<Node> delegate;

        BuildOperationAwareExecutionAction(BuildOperationRef parentOperation, Action<Node> delegate) {
            this.parentOperation = parentOperation;
            this.delegate = delegate;
        }

        @Override
        public void execute(Node node) {
            CurrentBuildOperationRef.instance().with(this.parentOperation, () -> this.delegate.execute(node));
        }
    }
}

