/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildTaskScheduler;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.selection.BuildTaskSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNameResolvingBuildTaskScheduler
implements BuildTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildTaskScheduler.class);
    private final CommandLineTaskParser commandLineTaskParser;
    private final BuildTaskSelector.BuildSpecificSelector taskSelector;

    public TaskNameResolvingBuildTaskScheduler(CommandLineTaskParser commandLineTaskParser, BuildTaskSelector.BuildSpecificSelector taskSelector) {
        this.commandLineTaskParser = commandLineTaskParser;
        this.taskSelector = taskSelector;
    }

    @Override
    public void scheduleRequestedTasks(GradleInternal gradle, @Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        if (selector != null) {
            selector.applyTasksTo(new EntryTaskSelectorContext(gradle), plan);
        }
        List<TaskExecutionRequest> taskParameters = gradle.getStartParameter().getTaskRequests();
        for (TaskExecutionRequest taskParameter : taskParameters) {
            List<TaskSelection> taskSelections = this.commandLineTaskParser.parseTasks(taskParameter);
            for (TaskSelection taskSelection : taskSelections) {
                LOGGER.info("Selected primary task '{}' from project {}", (Object)taskSelection.getTaskName(), (Object)taskSelection.getProjectPath());
                plan.addEntryTasks(taskSelection.getTasks());
            }
        }
    }

    @NonNullApi
    private class EntryTaskSelectorContext
    implements EntryTaskSelector.Context {
        final GradleInternal gradle;

        public EntryTaskSelectorContext(GradleInternal gradle) {
            this.gradle = gradle;
        }

        @Override
        public TaskSelection getSelection(String taskPath) {
            return TaskNameResolvingBuildTaskScheduler.this.taskSelector.resolveTaskName(taskPath);
        }

        @Override
        public GradleInternal getGradle() {
            return this.gradle;
        }
    }
}

