/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ProjectDependencyObservedListener;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.Build.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J*\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gradle/configurationcache/RelevantProjectsRegistry;", "Lorg/gradle/api/internal/artifacts/configurations/ProjectDependencyObservedListener;", "build", "Lorg/gradle/internal/build/BuildState;", "(Lorg/gradle/internal/build/BuildState;)V", "targetProjects", "", "Lorg/gradle/api/internal/project/ProjectState;", "collect", "", "project", "projects", "dependencyObserved", "consumingProject", "targetProject", "requestedState", "Lorg/gradle/api/internal/artifacts/configurations/ConfigurationInternal$InternalState;", "target", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/projectresult/ResolvedProjectConfiguration;", "isLocalProject", "", "projectState", "projectStateOf", "node", "Lorg/gradle/execution/plan/Node;", "relevantProjects", "", "nodes", "", "configuration-cache"})
public final class RelevantProjectsRegistry
implements ProjectDependencyObservedListener {
    @NotNull
    private final BuildState build;
    @NotNull
    private final Set<ProjectState> targetProjects;

    public RelevantProjectsRegistry(@NotNull BuildState build2) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        this.build = build2;
        this.targetProjects = new LinkedHashSet();
    }

    @NotNull
    public final Set<ProjectState> relevantProjects(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Set result2 = new LinkedHashSet();
        for (ProjectState projectState : this.targetProjects) {
            this.collect(projectState, result2);
        }
        for (Node node : nodes) {
            ProjectState project = this.projectStateOf(node);
            if (project == null || !this.isLocalProject(project)) continue;
            this.collect(project, result2);
        }
        return result2;
    }

    private final void collect(ProjectState project, Set<ProjectState> projects) {
        if (!projects.add(project)) {
            return;
        }
        ProjectState parent = project.getParent();
        if (parent != null) {
            this.collect(parent, projects);
        }
    }

    private final ProjectState projectStateOf(Node node) {
        ProjectInternal projectInternal = node.getOwningProject();
        return projectInternal != null ? projectInternal.getOwner() : null;
    }

    private final boolean isLocalProject(ProjectState projectState) {
        return projectState.getOwner() == this.build;
    }

    @Override
    public void dependencyObserved(@Nullable ProjectState consumingProject, @NotNull ProjectState targetProject, @NotNull ConfigurationInternal.InternalState requestedState, @NotNull ResolvedProjectConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)targetProject, (String)"targetProject");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedState), (String)"requestedState");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.targetProjects.add(targetProject);
    }
}

