/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DefaultSection;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyReportHeader;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RequestedVersion;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.ResolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.Section;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyResultSorter;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.CollectionUtils;

public class DependencyInsightReporter {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private static final InternalTransformer<DependencyEdge, DependencyResult> TO_EDGES = result2 -> {
        if (result2 instanceof UnresolvedDependencyResult) {
            return new UnresolvedDependencyEdge((UnresolvedDependencyResult)result2);
        }
        return new ResolvedDependencyEdge((ResolvedDependencyResult)result2);
    };

    public DependencyInsightReporter(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public Collection<RenderableDependency> convertToRenderableItems(Collection<DependencyResult> dependencies, boolean singlePathToDependency) {
        LinkedList<RenderableDependency> out = new LinkedList<RenderableDependency>();
        Collection<DependencyEdge> sortedEdges = this.toDependencyEdges(dependencies);
        HashSet annotated = Sets.newHashSet();
        HashSet alreadyReportedErrors = Sets.newHashSet();
        RequestedVersion current = null;
        for (DependencyEdge dependency : sortedEdges) {
            if (annotated.add(dependency.getActual())) {
                DependencyReportHeader header = this.createHeaderForDependency(dependency, alreadyReportedErrors);
                out.add(header);
                current = this.newRequestedVersion(out, dependency);
            } else if (!current.getRequested().equals(dependency.getRequested())) {
                current = this.newRequestedVersion(out, dependency);
            }
            if (singlePathToDependency && !current.getChildren().isEmpty()) continue;
            current.addChild(dependency);
        }
        return out;
    }

    private DependencyReportHeader createHeaderForDependency(DependencyEdge dependency, Set<Throwable> alreadyReportedErrors) {
        String reasonShortDescription;
        boolean displayFullReasonSection;
        ComponentSelectionReasonInternal reason = (ComponentSelectionReasonInternal)dependency.getReason();
        DefaultSection selectionReasonsSection = DependencyInsightReporter.buildSelectionReasonSection(reason);
        List<Section> reasonSections = selectionReasonsSection.getChildren();
        ArrayList extraDetails = Lists.newArrayList();
        boolean bl = displayFullReasonSection = reason.hasCustomDescriptions() || reasonSections.size() > 1;
        if (displayFullReasonSection) {
            reasonShortDescription = null;
            extraDetails.add(selectionReasonsSection);
        } else {
            reasonShortDescription = reasonSections.isEmpty() ? null : reasonSections.get(0).getDescription().toLowerCase();
        }
        DependencyInsightReporter.buildFailureSection(dependency, alreadyReportedErrors, extraDetails);
        return new DependencyReportHeader(dependency, reasonShortDescription, extraDetails);
    }

    private RequestedVersion newRequestedVersion(LinkedList<RenderableDependency> out, DependencyEdge dependency) {
        RequestedVersion current = new RequestedVersion(dependency.getRequested(), dependency.getActual(), dependency.isResolvable());
        out.add(current);
        return current;
    }

    private Collection<DependencyEdge> toDependencyEdges(Collection<DependencyResult> dependencies) {
        List<DependencyEdge> edges = CollectionUtils.collect(dependencies, TO_EDGES);
        return DependencyResultSorter.sort(edges, this.versionSelectorScheme, this.versionComparator, this.versionParser);
    }

    private static void buildFailureSection(DependencyEdge edge, Set<Throwable> alreadyReportedErrors, List<Section> sections) {
        if (edge instanceof UnresolvedDependencyEdge) {
            UnresolvedDependencyEdge unresolved = (UnresolvedDependencyEdge)edge;
            Throwable failure = unresolved.getFailure();
            DefaultSection failures = new DefaultSection("Failures");
            String errorMessage = DependencyInsightReporter.collectErrorMessages(failure, alreadyReportedErrors);
            failures.addChild(new DefaultSection(errorMessage));
            sections.add(failures);
        }
    }

    private static String collectErrorMessages(Throwable failure, Set<Throwable> alreadyReportedErrors) {
        TreeFormatter formatter = new TreeFormatter();
        DependencyInsightReporter.collectErrorMessages(failure, formatter, alreadyReportedErrors);
        return formatter.toString();
    }

    private static void collectErrorMessages(Throwable failure, TreeFormatter formatter, Set<Throwable> alreadyReportedErrors) {
        if (alreadyReportedErrors.add(failure)) {
            Throwable cause;
            formatter.node(failure.getMessage());
            if (failure instanceof ResolutionProvider) {
                ((ResolutionProvider)((Object)failure)).getResolutions().forEach(formatter::node);
            }
            if (alreadyReportedErrors.contains(cause = failure.getCause())) {
                formatter.append(" (already reported)");
            }
            if (cause != null && cause != failure) {
                formatter.startChildren();
                DependencyInsightReporter.collectErrorMessages(cause, formatter, alreadyReportedErrors);
                formatter.endChildren();
            }
        }
    }

    private static DefaultSection buildSelectionReasonSection(ComponentSelectionReason reason) {
        DefaultSection selectionReasons = new DefaultSection("Selection reasons");
        for (ComponentSelectionDescriptor entry : reason.getDescriptions()) {
            ComponentSelectionDescriptorInternal descriptor = (ComponentSelectionDescriptorInternal)entry;
            boolean hasCustomDescription = descriptor.hasCustomDescription();
            if (ComponentSelectionReasons.isCauseExpected(descriptor) && !hasCustomDescription) continue;
            DefaultSection item = new DefaultSection(DependencyInsightReporter.render(descriptor));
            selectionReasons.addChild(item);
        }
        return selectionReasons;
    }

    private static String render(ComponentSelectionDescriptor descriptor) {
        if (((ComponentSelectionDescriptorInternal)descriptor).hasCustomDescription()) {
            return DependencyInsightReporter.prettyCause(descriptor.getCause()) + ": " + descriptor.getDescription();
        }
        return DependencyInsightReporter.prettyCause(descriptor.getCause());
    }

    private static String prettyCause(ComponentSelectionCause cause) {
        switch (cause) {
            case ROOT: {
                return "Root component";
            }
            case REQUESTED: {
                return "Was requested";
            }
            case SELECTED_BY_RULE: {
                return "Selected by rule";
            }
            case FORCED: {
                return "Forced";
            }
            case CONFLICT_RESOLUTION: {
                return "By conflict resolution";
            }
            case COMPOSITE_BUILD: {
                return "By composite build";
            }
            case REJECTION: {
                return "Rejection";
            }
            case CONSTRAINT: {
                return "By constraint";
            }
            case BY_ANCESTOR: {
                return "By ancestor";
            }
        }
        assert (false) : "Missing an enum value " + (Object)((Object)cause);
        return cause.getDefaultReason();
    }
}

