/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.PropertyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.Pair;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class PropertyReportTask
extends AbstractProjectBasedReportTask<PropertyReportModel> {
    private PropertyReportRenderer renderer = new PropertyReportRenderer();
    private final Property<String> property = this.getProject().getObjects().property(String.class);

    @Incubating
    @Input
    @Optional
    @Option(option="property", description="A specific property to output")
    public Property<String> getProperty() {
        return this.property;
    }

    @Override
    @Internal
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(PropertyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    protected PropertyReportModel calculateReportModelFor(Project project) {
        return this.computePropertyReportModel(project);
    }

    private PropertyReportModel computePropertyReportModel(Project project) {
        PropertyReportModel model = new PropertyReportModel();
        Map<String, ?> projectProperties = project.getProperties();
        if (this.property.isPresent()) {
            String propertyName = (String)this.property.get();
            if ("properties".equals(propertyName)) {
                model.putProperty(propertyName, "{...}");
            } else {
                model.putProperty(propertyName, projectProperties.get(propertyName));
            }
        } else {
            for (Map.Entry<String, ?> entry : new TreeMap(projectProperties).entrySet()) {
                if ("properties".equals(entry.getKey())) {
                    model.putProperty(entry.getKey(), "{...}");
                    continue;
                }
                model.putProperty(entry.getKey(), entry.getValue());
            }
        }
        return model;
    }

    @Override
    protected void generateReportFor(ProjectDetails project, PropertyReportModel model) {
        for (PropertyWarning warning : model.warnings) {
            this.getLogger().warn("Rendering of the property '{}' with value type '{}' failed with exception", new Object[]{warning.name, warning.valueClass, warning.exception});
        }
        for (Pair entry : model.properties) {
            this.renderer.addProperty((String)entry.getLeft(), entry.getRight());
        }
    }

    private static class PropertyWarning {
        private final String name;
        private final String valueClass;
        private final Exception exception;

        private PropertyWarning(String name, String valueClass, Exception exception) {
            this.name = name;
            this.valueClass = valueClass;
            this.exception = exception;
        }
    }

    @Incubating
    public static final class PropertyReportModel {
        private final List<PropertyWarning> warnings = new ArrayList<PropertyWarning>();
        private final List<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();

        private PropertyReportModel() {
        }

        private void putProperty(String name, @Nullable Object value) {
            String strValue;
            try {
                strValue = String.valueOf(value);
            }
            catch (Exception e) {
                String valueClass = value != null ? String.valueOf(value.getClass()) : "null";
                this.warnings.add(new PropertyWarning(name, valueClass, e));
                strValue = valueClass + " [Rendering failed]";
            }
            this.properties.add(Pair.of(name, strValue));
        }
    }
}

