/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.MavenVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.internal.component.MavenPublishingAwareVariant;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenPomDependencies;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenPomDependencies;
import org.gradle.api.publish.maven.internal.dependencies.VersionRangeMapper;
import org.gradle.api.publish.maven.internal.validation.MavenPublicationErrorChecker;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.Path;

public class MavenComponentParser {
    @VisibleForTesting
    public static final String INCOMPATIBLE_FEATURE = " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.";
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published pom file.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'pom' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Maven.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private static final Logger LOG = Logging.getLogger(MavenComponentParser.class);
    private final PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(LOG, " contains dependencies that cannot be represented in a published pom file.", " contains dependencies that will produce a pom file that cannot be consumed by a Maven client.", "These issues indicate information that is lost in the published 'pom' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Maven.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.", "suppressPomMetadataWarningsFor");
    private final PlatformSupport platformSupport;
    private final VersionRangeMapper versionRangeMapper;
    private final DocumentationRegistry documentationRegistry;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final NotationParser<Object, MavenArtifact> mavenArtifactParser;

    public MavenComponentParser(PlatformSupport platformSupport, VersionRangeMapper versionRangeMapper, DocumentationRegistry documentationRegistry, ProjectDependencyPublicationResolver projectDependencyResolver, NotationParser<Object, MavenArtifact> mavenArtifactParser) {
        this.platformSupport = platformSupport;
        this.versionRangeMapper = versionRangeMapper;
        this.documentationRegistry = documentationRegistry;
        this.projectDependencyResolver = projectDependencyResolver;
        this.mavenArtifactParser = mavenArtifactParser;
    }

    public Set<MavenArtifact> parseArtifacts(SoftwareComponentInternal component) {
        HashSet seenArtifacts = Sets.newHashSet();
        return component.getUsages().stream().sorted(Comparator.comparing(MavenPublishingAwareVariant::scopeForVariant)).flatMap(variant -> variant.getArtifacts().stream()).filter(artifact -> {
            ArtifactKey key = new ArtifactKey(artifact.getFile(), artifact.getClassifier(), artifact.getExtension());
            return seenArtifacts.add(key);
        }).map(this.mavenArtifactParser::parseNotation).collect(Collectors.toSet());
    }

    public DependencyResult parseDependencies(SoftwareComponentInternal component, ModuleVersionIdentifier coordinates, VersionMappingStrategyInternal versionMappingStrategy) {
        MavenPublicationErrorChecker.checkForUnpublishableAttributes(component, this.documentationRegistry);
        HashSet seenDependencies = Sets.newHashSet();
        HashSet seenConstraints = Sets.newHashSet();
        ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>();
        ArrayList<MavenDependency> constraints = new ArrayList<MavenDependency>();
        ArrayList<MavenDependency> platforms = new ArrayList<MavenDependency>();
        for (SoftwareComponentVariant variant : MavenComponentParser.getSortedVariants(component)) {
            this.publicationWarningsCollector.newContext(variant.getName());
            MavenPublishingAwareVariant.ScopeMapping scopeMapping = MavenPublishingAwareVariant.scopeForVariant(variant);
            String scope = scopeMapping.getScope();
            boolean optional = scopeMapping.isOptional();
            Set<ExcludeRule> globalExcludes = variant.getGlobalExcludes();
            ImmutableAttributes attributes = ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
            MavenDependencyFactory dependencyFactory = new MavenDependencyFactory(this.projectDependencyResolver, this.versionRangeMapper, versionMappingStrategy.findStrategyForVariant(attributes), this.publicationWarningsCollector);
            for (ModuleDependency moduleDependency : variant.getDependencies()) {
                if (!seenDependencies.add(PublishedDependency.of(moduleDependency)) || MavenComponentParser.isDependencyWithDefaultArtifact(moduleDependency) && MavenComponentParser.dependencyMatchesProject(moduleDependency, coordinates)) continue;
                if (this.platformSupport.isTargetingPlatform(moduleDependency)) {
                    if (moduleDependency instanceof ProjectDependency) {
                        platforms.add(dependencyFactory.asImportDependencyConstraint((ProjectDependency)moduleDependency));
                        continue;
                    }
                    platforms.add(dependencyFactory.asImportDependencyConstraint(moduleDependency));
                    continue;
                }
                if (!moduleDependency.getAttributes().isEmpty()) {
                    this.publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", moduleDependency.getGroup(), moduleDependency.getName(), moduleDependency.getVersion()));
                }
                if (moduleDependency instanceof ProjectDependency) {
                    dependencies.add(dependencyFactory.asDependency((ProjectDependency)moduleDependency, scope, optional, globalExcludes));
                    continue;
                }
                dependencies.addAll(dependencyFactory.asDependencies(moduleDependency, scope, optional, globalExcludes));
            }
            for (DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
                if (!seenConstraints.add(dependencyConstraint)) continue;
                if (dependencyConstraint instanceof DefaultProjectDependencyConstraint) {
                    constraints.add(dependencyFactory.asDependencyConstraint((DefaultProjectDependencyConstraint)dependencyConstraint));
                    continue;
                }
                if (dependencyConstraint.getVersion() != null) {
                    constraints.add(dependencyFactory.asDependencyConstraint(dependencyConstraint));
                    continue;
                }
                this.publicationWarningsCollector.addIncompatible(String.format("constraint %s:%s declared with a Maven incompatible version notation", dependencyConstraint.getGroup(), dependencyConstraint.getName()));
            }
            if (variant.getCapabilities().isEmpty()) continue;
            for (Capability capability : variant.getCapabilities()) {
                if (!MavenComponentParser.isNotDefaultCapability(capability, coordinates)) continue;
                this.publicationWarningsCollector.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Maven", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
        return new DependencyResult(new DefaultMavenPomDependencies((ImmutableList<MavenDependency>)ImmutableList.copyOf(dependencies), (ImmutableList<MavenDependency>)ImmutableList.builder().addAll(constraints).addAll(platforms).build()), this.publicationWarningsCollector);
    }

    private static boolean isNotDefaultCapability(Capability capability, ModuleVersionIdentifier coordinates) {
        return !coordinates.getGroup().equals(capability.getGroup()) || !coordinates.getName().equals(capability.getName()) || !coordinates.getVersion().equals(capability.getVersion());
    }

    private static boolean isDependencyWithDefaultArtifact(ModuleDependency dependency) {
        if (dependency.getArtifacts().isEmpty()) {
            return true;
        }
        return dependency.getArtifacts().stream().allMatch(artifact -> Strings.nullToEmpty((String)artifact.getClassifier()).isEmpty());
    }

    private static boolean dependencyMatchesProject(ModuleDependency dependency, ModuleVersionIdentifier coordinates) {
        return coordinates.getModule().equals(DefaultModuleIdentifier.newId(dependency.getGroup(), dependency.getName()));
    }

    private static List<SoftwareComponentVariant> getSortedVariants(SoftwareComponentInternal component) {
        return component.getUsages().stream().sorted(Comparator.comparing(MavenPublishingAwareVariant::scopeForVariant)).collect(Collectors.toList());
    }

    private static class PublishedDependency {
        private final String group;
        private final String name;
        private final String targetConfiguration;
        private final AttributeContainer attributes;
        private final Set<DependencyArtifact> artifacts;
        private final Set<ExcludeRule> excludeRules;
        private final List<Capability> requestedCapabilities;

        private PublishedDependency(String group, String name, String targetConfiguration, AttributeContainer attributes, Set<DependencyArtifact> artifacts2, Set<ExcludeRule> excludeRules, List<Capability> requestedCapabilities) {
            this.group = group;
            this.name = name;
            this.targetConfiguration = targetConfiguration;
            this.attributes = attributes;
            this.artifacts = artifacts2;
            this.excludeRules = excludeRules;
            this.requestedCapabilities = requestedCapabilities;
        }

        static PublishedDependency of(ModuleDependency dep) {
            return new PublishedDependency(dep.getGroup(), dep.getName(), dep.getTargetConfiguration(), dep.getAttributes(), dep.getArtifacts(), dep.getExcludeRules(), dep.getRequestedCapabilities());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublishedDependency that = (PublishedDependency)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.targetConfiguration, (Object)that.targetConfiguration) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.artifacts, that.artifacts) && Objects.equal(this.excludeRules, that.excludeRules) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.targetConfiguration, this.attributes, this.artifacts, this.excludeRules, this.requestedCapabilities});
        }
    }

    private static class ArtifactKey {
        final File file;
        final String classifier;
        final String extension;

        public ArtifactKey(File file, @Nullable String classifier, @Nullable String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public boolean equals(Object obj) {
            ArtifactKey other = (ArtifactKey)obj;
            return this.file.equals(other.file) && Objects.equal((Object)this.classifier, (Object)other.classifier) && Objects.equal((Object)this.extension, (Object)other.extension);
        }

        public int hashCode() {
            return this.file.hashCode() ^ Objects.hashCode((Object[])new Object[]{this.classifier, this.extension});
        }
    }

    private static class Coordinates {
        public final String group;
        public final String name;
        public final String version;

        public Coordinates(String group, String name, @Nullable String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        public static Coordinates from(ModuleVersionIdentifier identifier) {
            return new Coordinates(identifier.getGroup(), identifier.getName(), identifier.getVersion());
        }
    }

    public static class DependencyResult {
        private final MavenPomDependencies dependencies;
        private final PublicationWarningsCollector warnings;

        public DependencyResult(MavenPomDependencies dependencies, PublicationWarningsCollector warnings) {
            this.warnings = warnings;
            this.dependencies = dependencies;
        }

        public MavenPomDependencies getDependencies() {
            return this.dependencies;
        }

        public PublicationWarningsCollector getWarnings() {
            return this.warnings;
        }
    }

    private static class MavenDependencyFactory {
        private final ProjectDependencyPublicationResolver projectDependencyResolver;
        private final VersionRangeMapper versionRangeMapper;
        private final VariantVersionMappingStrategyInternal versionMappingStrategy;
        private final PublicationWarningsCollector publicationWarningsCollector;

        public MavenDependencyFactory(ProjectDependencyPublicationResolver projectDependencyResolver, VersionRangeMapper versionRangeMapper, VariantVersionMappingStrategyInternal versionMappingStrategy, PublicationWarningsCollector publicationWarningsCollector) {
            this.projectDependencyResolver = projectDependencyResolver;
            this.versionRangeMapper = versionRangeMapper;
            this.versionMappingStrategy = versionMappingStrategy;
            this.publicationWarningsCollector = publicationWarningsCollector;
        }

        private List<MavenDependency> asDependencies(ModuleDependency dependency, String scope, boolean optional, Set<ExcludeRule> globalExcludes) {
            Set<ExcludeRule> allExcludeRules = MavenDependencyFactory.getExcludeRules(globalExcludes, dependency);
            if (dependency.getArtifacts().isEmpty()) {
                Coordinates coordinates = this.resolveCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion(), null);
                return Collections.singletonList(MavenDependencyFactory.newDependency(coordinates, null, null, scope, allExcludeRules, optional));
            }
            ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>();
            for (DependencyArtifact artifact : dependency.getArtifacts()) {
                Coordinates coordinates = this.resolveCoordinates(dependency.getGroup(), artifact.getName(), dependency.getVersion(), null);
                dependencies.add(MavenDependencyFactory.newDependency(coordinates, artifact.getType(), artifact.getClassifier(), scope, allExcludeRules, optional));
            }
            return dependencies;
        }

        private MavenDependency asDependency(ProjectDependency dependency, String scope, boolean optional, Set<ExcludeRule> globalExcludes) {
            Path identityPath = MavenDependencyFactory.getIdentityPath(dependency);
            Coordinates coordinates = this.resolveCoordinates(identityPath);
            Set<ExcludeRule> allExcludeRules = MavenDependencyFactory.getExcludeRules(globalExcludes, dependency);
            return MavenDependencyFactory.newDependency(coordinates, null, null, scope, allExcludeRules, optional);
        }

        private MavenDependency asDependencyConstraint(DependencyConstraint dependency) {
            Coordinates coordinates = this.resolveCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion(), null);
            return MavenDependencyFactory.newDependency(coordinates, null, null, null, Collections.emptySet(), false);
        }

        private MavenDependency asDependencyConstraint(DefaultProjectDependencyConstraint dependency) {
            Path identityPath = MavenDependencyFactory.getIdentityPath(dependency.getProjectDependency());
            Coordinates coordinates = this.resolveCoordinates(identityPath);
            return MavenDependencyFactory.newDependency(coordinates, null, null, null, Collections.emptySet(), false);
        }

        private MavenDependency asImportDependencyConstraint(ModuleDependency dependency) {
            Coordinates coordinates = this.resolveCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion(), null);
            return MavenDependencyFactory.newDependency(coordinates, "pom", null, "import", Collections.emptySet(), false);
        }

        private MavenDependency asImportDependencyConstraint(ProjectDependency dependency) {
            Path identityPath = MavenDependencyFactory.getIdentityPath(dependency);
            Coordinates coordinates = this.resolveCoordinates(identityPath);
            return MavenDependencyFactory.newDependency(coordinates, "pom", null, "import", Collections.emptySet(), false);
        }

        private Coordinates resolveCoordinates(Path identityPath) {
            ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, identityPath);
            return this.resolveCoordinates(identifier.getGroup(), identifier.getName(), identifier.getVersion(), identityPath);
        }

        private Coordinates resolveCoordinates(String groupId, String artifactId, @Nullable String version, @Nullable Path identityPath) {
            ModuleVersionIdentifier resolvedVersion = this.versionMappingStrategy.maybeResolveVersion(groupId, artifactId, identityPath);
            if (resolvedVersion != null) {
                return Coordinates.from(resolvedVersion);
            }
            if (version == null) {
                return new Coordinates(groupId, artifactId, null);
            }
            if (DefaultVersionSelectorScheme.isSubVersion(version) || DefaultVersionSelectorScheme.isLatestVersion(version) && !MavenVersionSelectorScheme.isSubstituableLatest(version)) {
                this.publicationWarningsCollector.addIncompatible(String.format("%s:%s:%s declared with a Maven incompatible version notation", groupId, artifactId, version));
            }
            return new Coordinates(groupId, artifactId, this.versionRangeMapper.map(version));
        }

        private static MavenDependency newDependency(Coordinates coordinates, @Nullable String type, @Nullable String classifier, @Nullable String scope, Set<ExcludeRule> excludeRules, boolean optional) {
            return new DefaultMavenDependency(coordinates.group, coordinates.name, coordinates.version, type, classifier, scope, excludeRules, optional);
        }

        private static Path getIdentityPath(ProjectDependency dependency) {
            return ((ProjectDependencyInternal)dependency).getIdentityPath();
        }

        private static Set<ExcludeRule> getExcludeRules(Set<ExcludeRule> globalExcludes, ModuleDependency dependency) {
            if (!dependency.isTransitive()) {
                return EXCLUDE_ALL_RULE;
            }
            Set<ExcludeRule> excludeRules = dependency.getExcludeRules();
            if (excludeRules.isEmpty()) {
                return globalExcludes;
            }
            if (globalExcludes.isEmpty()) {
                return excludeRules;
            }
            return Sets.union(globalExcludes, excludeRules);
        }
    }
}

