/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.util.Optional;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.publish.internal.metadata.DependencyAttributesValidator;

public class EnforcedPlatformPublicationValidator
implements DependencyAttributesValidator {
    private static final String SUPPRESSION = "enforced-platform";
    private static final String LONG_EXPLANATION = "In general publishing dependencies to enforced platforms is a mistake: enforced platforms shouldn't be used for published components because they behave like forced dependencies and leak to consumers. This can result in hard to diagnose dependency resolution errors.";

    @Override
    public String getSuppressor() {
        return SUPPRESSION;
    }

    @Override
    public String getExplanation() {
        return LONG_EXPLANATION;
    }

    @Override
    public Optional<String> validationErrorFor(String group, String name, AttributeContainer attributes) {
        Category category = attributes.getAttribute(Category.CATEGORY_ATTRIBUTE);
        if (category != null && SUPPRESSION.equals(category.getName())) {
            return Optional.of("contains a dependency on enforced platform '" + group + ":" + name + "'");
        }
        return Optional.empty();
    }
}

