/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.VersionNumber;

public abstract class PmdPlugin
extends AbstractCodeQualityPlugin<Pmd> {
    public static final String DEFAULT_PMD_VERSION = "6.55.0";
    private static final String PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION = "pmdAux";
    private PmdExtension extension;

    @Override
    protected String getToolName() {
        return "PMD";
    }

    @Override
    protected Class<Pmd> getTaskType() {
        return Pmd.class;
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("pmd", PmdExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_PMD_VERSION);
        this.extension.getRulesMinimumPriority().convention(5);
        this.extension.getIncrementalAnalysis().convention(true);
        this.extension.getMaxFailures().convention(0);
        this.extension.getThreads().convention(1);
        this.extension.setRuleSetFiles(this.project.getLayout().files(new Object[0]));
        this.extension.ruleSetsConvention(this.project.getProviders().provider(() -> PmdPlugin.ruleSetsConvention(this.extension)));
        PmdPlugin.conventionMappingOf(this.extension).map("targetJdk", () -> this.getDefaultTargetJdk(this.getJavaPluginExtension().getSourceCompatibility()));
        return this.extension;
    }

    public TargetJdk getDefaultTargetJdk(JavaVersion javaVersion) {
        try {
            return TargetJdk.toVersion(javaVersion.toString());
        }
        catch (IllegalArgumentException ignored) {
            return TargetJdk.VERSION_1_4;
        }
    }

    @Override
    protected void createConfigurations() {
        super.createConfigurations();
        Configuration auxClasspath = this.project.getConfigurations().dependencyScopeUnlocked(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION, additionalAuxDepsConfiguration -> {
            additionalAuxDepsConfiguration.setDescription("The additional libraries that are available for type resolution during analysis");
            additionalAuxDepsConfiguration.setVisible(false);
        });
        this.getJvmPluginServices().configureAsRuntimeClasspath(auxClasspath);
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Pmd task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
        this.configureToolchains(task);
    }

    private static List<String> ruleSetsConvention(PmdExtension extension) {
        if (extension.getRuleSetConfig() == null && extension.getRuleSetFiles().isEmpty()) {
            return new ArrayList<String>(Collections.singletonList("category/java/errorprone.xml"));
        }
        return Collections.emptyList();
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> PmdPlugin.calculateDefaultDependencyNotation(this.extension.getToolVersion()).stream().map(this.project.getDependencies()::create).forEach(dependencies::add));
    }

    private void configureTaskConventionMapping(Configuration configuration, Pmd task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("pmdClasspath", () -> configuration);
        taskMapping.map("ruleSets", () -> this.extension.getRuleSets());
        taskMapping.map("ruleSetConfig", () -> this.extension.getRuleSetConfig());
        taskMapping.map("ruleSetFiles", () -> this.extension.getRuleSetFiles());
        taskMapping.map("consoleOutput", () -> this.extension.isConsoleOutput());
        taskMapping.map("targetJdk", () -> this.extension.getTargetJdk());
        task.getRulesMinimumPriority().convention(this.extension.getRulesMinimumPriority());
        task.getMaxFailures().convention(this.extension.getMaxFailures());
        task.getIncrementalAnalysis().convention(this.extension.getIncrementalAnalysis());
        task.getThreads().convention(this.extension.getThreads());
        task.getIgnoreFailuresProperty().convention(this.project.provider(() -> this.extension.isIgnoreFailures()));
    }

    private void configureReportsConventionMapping(Pmd task, String baseName) {
        ProjectLayout layout2 = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider<RegularFile> reportsDir = layout2.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action(report2 -> {
            report2.getRequired().convention(true);
            report2.getOutputLocation().convention(layout2.getProjectDirectory().file(providers.provider(() -> {
                String reportFileName = baseName + "." + report2.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), reportFileName).getAbsolutePath();
            })));
        }));
    }

    private void configureToolchains(Pmd task) {
        Provider<JavaLauncher> javaLauncherProvider = this.getToolchainService().launcherFor(new CurrentJvmToolchainSpec(this.project.getObjects()));
        task.getJavaLauncher().convention(javaLauncherProvider);
        this.project.getPluginManager().withPlugin("java-base", p -> {
            JavaToolchainSpec toolchain = this.getJavaPluginExtension().getToolchain();
            task.getJavaLauncher().convention(this.getToolchainService().launcherFor(toolchain).orElse(javaLauncherProvider));
        });
    }

    @VisibleForTesting
    static Set<String> calculateDefaultDependencyNotation(String versionString) {
        VersionNumber toolVersion = VersionNumber.parse(versionString);
        if (toolVersion.compareTo(VersionNumber.version(5)) < 0) {
            return Collections.singleton("pmd:pmd:" + versionString);
        }
        if (toolVersion.compareTo(VersionNumber.parse("5.2.0")) < 0) {
            return Collections.singleton("net.sourceforge.pmd:pmd:" + versionString);
        }
        if (toolVersion.compareTo(VersionNumber.version(7)) < 0) {
            return Collections.singleton("net.sourceforge.pmd:pmd-java:" + versionString);
        }
        return ImmutableSet.of((Object)("net.sourceforge.pmd:pmd-java:" + versionString), (Object)("net.sourceforge.pmd:pmd-ant:" + versionString));
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Pmd task) {
        task.setDescription("Run PMD analysis for " + sourceSet.getName() + " classes");
        task.setSource(sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        Configuration pmdAdditionalAuxDepsConfiguration = configurations.getByName(PMD_ADDITIONAL_AUX_DEPS_CONFIGURATION);
        Configuration pmdAuxClasspath = configurations.migratingUnlocked(sourceSet.getName() + "PmdAuxClasspath", ConfigurationRolesForMigration.RESOLVABLE_DEPENDENCY_SCOPE_TO_RESOLVABLE);
        pmdAuxClasspath.extendsFrom(compileClasspath, pmdAdditionalAuxDepsConfiguration);
        pmdAuxClasspath.setVisible(false);
        this.getJvmPluginServices().configureAsRuntimeClasspath(pmdAuxClasspath);
        taskMapping.map("classpath", () -> {
            FileCollection nonConfigurationClasspathEntries = sourceSet.getCompileClasspath().minus(compileClasspath);
            return sourceSet.getOutput().plus(nonConfigurationClasspathEntries).plus(pmdAuxClasspath);
        });
    }
}

