/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.testing.DefaultAggregateTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AggregateTestReport;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;

@Incubating
public abstract class TestReportAggregationPlugin
implements Plugin<Project> {
    public static final String TEST_REPORT_AGGREGATION_CONFIGURATION_NAME = "testReportAggregation";

    @Inject
    protected abstract JvmPluginServices getJvmPluginServices();

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        Configuration testAggregation = (Configuration)configurations.dependencyScope(TEST_REPORT_AGGREGATION_CONFIGURATION_NAME).get();
        testAggregation.setDescription("A configuration to collect test execution results");
        testAggregation.setVisible(false);
        ReportingExtension reporting = project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(AggregateTestReport.class, DefaultAggregateTestReport.class);
        ObjectFactory objects = project.getObjects();
        Property testReportDirectory = objects.directoryProperty().convention(reporting.getBaseDirectory().dir("tests"));
        project.getPlugins().withId("java-base", arg_0 -> TestReportAggregationPlugin.lambda$apply$0(project, (DirectoryProperty)testReportDirectory, arg_0));
        Configuration testResultsConf = (Configuration)configurations.resolvable("aggregateTestReportResults").get();
        testResultsConf.extendsFrom(testAggregation);
        testResultsConf.setDescription("Graph needed for the aggregated test results report.");
        testResultsConf.setVisible(false);
        reporting.getReports().withType(AggregateTestReport.class).all(arg_0 -> TestReportAggregationPlugin.lambda$apply$8(testResultsConf, objects, (DirectoryProperty)testReportDirectory, arg_0));
        project.getPlugins().withType(JavaBasePlugin.class, plugin -> this.getJvmPluginServices().configureAsRuntimeClasspath(testAggregation));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            testAggregation.getDependencies().add(project.getDependencyFactory().create(project));
            TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer<TestSuite> testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "AggregateTestReport", AggregateTestReport.class, report2 -> report2.getTestType().convention(testSuite.getTestType())));
        });
    }

    private static /* synthetic */ void lambda$apply$8(Configuration testResultsConf, ObjectFactory objects, DirectoryProperty testReportDirectory, AggregateTestReport report2) {
        report2.getReportTask().configure(task -> {
            Callable<FileCollection> testResults = () -> testResultsConf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
                    attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report2.getTestType().map(tt -> objects.named(TestSuiteType.class, (String)tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "test-results"));
                });
            }).getFiles();
            task.getTestResults().from(testResults);
            task.getDestinationDirectory().convention(testReportDirectory.dir(report2.getTestType().map(tt -> tt + "/aggregated-results")));
        });
    }

    private static /* synthetic */ void lambda$apply$0(Project project, DirectoryProperty testReportDirectory, Plugin plugin) {
        JavaPluginExtension javaPluginExtension = project.getExtensions().getByType(JavaPluginExtension.class);
        testReportDirectory.convention((Provider)javaPluginExtension.getTestReportDir());
    }
}

