/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.jvm.component.internal.DefaultJvmSoftwareComponent;

public abstract class JavaTestFixturesPlugin
implements Plugin<Project> {
    @Inject
    public JavaTestFixturesPlugin() {
    }

    @Override
    public void apply(Project project) {
        project.getPlugins().apply(JavaBasePlugin.class);
        JavaPluginExtension extension = project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet testFixturesSourceSet = (SourceSet)extension.getSourceSets().maybeCreate("testFixtures");
        DefaultJvmFeature feature = new DefaultJvmFeature("testFixtures", testFixturesSourceSet, Collections.singletonList(new ProjectDerivedCapability(project, "testFixtures")), (ProjectInternal)project, true, false);
        feature.withApi();
        project.getPluginManager().withPlugin("java", plugin -> {
            DefaultJvmSoftwareComponent component = (DefaultJvmSoftwareComponent)JavaPluginHelper.getJavaComponent(project);
            component.addVariantsFromConfiguration(feature.getApiElementsConfiguration(), new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(feature.getRuntimeElementsConfiguration(), new JavaConfigurationVariantMapping("runtime", true));
            this.createImplicitTestFixturesDependencies(feature, project);
        });
    }

    private void createImplicitTestFixturesDependencies(JvmFeatureInternal feature, Project project) {
        DependencyHandler dependencies = project.getDependencies();
        feature.getApiConfiguration().getDependencies().add(dependencies.create(project));
        SourceSet testSourceSet = JavaPluginHelper.getDefaultTestSuite(project).getSources();
        Configuration testImplementation = project.getConfigurations().getByName(testSourceSet.getImplementationConfigurationName());
        testImplementation.getDependencies().add(dependencies.testFixtures(dependencies.create(project)));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath(project.getObjects().fileCollection().from(configurations.getByName(testSourceSet.getCompileClasspathConfigurationName())));
        testSourceSet.setRuntimeClasspath(project.getObjects().fileCollection().from(testSourceSet.getOutput(), configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName())));
    }
}

