/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.file.DefaultConfigurableFilePermissions;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.WorkResult;

public class DefaultFileSystemOperations
implements FileSystemOperations {
    private final ObjectFactory objectFactory;
    private final FileOperations fileOperations;

    public DefaultFileSystemOperations(ObjectFactory objectFactory, FileOperations fileOperations) {
        this.objectFactory = objectFactory;
        this.fileOperations = fileOperations;
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileOperations.copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileOperations.sync(action);
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.fileOperations.delete(action);
    }

    @Override
    public ConfigurableFilePermissions filePermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.permissions(false, configureAction);
    }

    @Override
    public ConfigurableFilePermissions directoryPermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.permissions(true, configureAction);
    }

    @Override
    public ConfigurableFilePermissions permissions(String unixNumericOrSymbolic) {
        return this.permissions(false, filePermissions -> filePermissions.unix(unixNumericOrSymbolic));
    }

    @Override
    public ConfigurableFilePermissions permissions(int unixNumeric) {
        return this.permissions(false, filePermissions -> filePermissions.unix(unixNumeric));
    }

    @Override
    public Provider<ConfigurableFilePermissions> permissions(Provider<String> permissions) {
        return permissions.map(SerializableLambdas.transformer(this::permissions));
    }

    private ConfigurableFilePermissions permissions(boolean directory, Action<? super ConfigurableFilePermissions> configureAction) {
        ConfigurableFilePermissions permissions = this.objectFactory.newInstance(DefaultConfigurableFilePermissions.class, this.objectFactory, DefaultConfigurableFilePermissions.getDefaultUnixNumeric(directory));
        configureAction.execute(permissions);
        return permissions;
    }
}

