/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public class AttributeDesugaring {
    private final Map<ImmutableAttributes, ImmutableAttributes> desugared = Maps.newIdentityHashMap();
    private final ImmutableAttributesFactory attributesFactory;

    public AttributeDesugaring(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public ImmutableAttributes desugar(ImmutableAttributes attributes) {
        if (attributes.isEmpty()) {
            return attributes;
        }
        return this.desugared.computeIfAbsent(attributes, key -> {
            AttributeContainerInternal mutable = this.attributesFactory.mutable();
            ImmutableSet<Attribute<?>> keySet = key.keySet();
            for (Attribute attribute : keySet) {
                Object value = key.getAttribute(attribute);
                Attribute desugared = (Attribute)Cast.uncheckedCast(attribute);
                if (attribute.getType() == Boolean.class || attribute.getType() == String.class) {
                    mutable.attribute(desugared, value);
                    continue;
                }
                desugared = (Attribute)Cast.uncheckedCast(Attribute.of(attribute.getName(), String.class));
                mutable.attribute(desugared, value.toString());
            }
            return mutable.asImmutable();
        });
    }

    public ComponentSelector desugarSelector(ComponentSelector selector) {
        DefaultProjectComponentSelector project;
        AttributeContainer projectAttributes;
        ModuleComponentSelector module;
        AttributeContainer moduleAttributes;
        if (selector instanceof ModuleComponentSelector && !(moduleAttributes = (module = (ModuleComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)moduleAttributes).asImmutable();
            return DefaultModuleComponentSelector.newSelector(module.getModuleIdentifier(), module.getVersionConstraint(), this.desugar(attributes), module.getRequestedCapabilities());
        }
        if (selector instanceof DefaultProjectComponentSelector && !(projectAttributes = (project = (DefaultProjectComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)projectAttributes).asImmutable();
            return new DefaultProjectComponentSelector(project.getBuildIdentifier(), project.getIdentityPath(), project.projectPath(), project.getProjectName(), this.desugar(attributes), project.getRequestedCapabilities());
        }
        return selector;
    }
}

