/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceServices;
import org.gradle.api.provider.Provider;
import org.gradle.cache.Cache;
import org.gradle.cache.ManualEvictionInMemoryCache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.ReservedFileSystemLocation;

@NotThreadSafe
public class MutableTransformWorkspaceServices
implements TransformWorkspaceServices,
ReservedFileSystemLocation {
    private final Cache<UnitOfWork.Identity, Try<TransformExecutionResult>> identityCache = new ManualEvictionInMemoryCache<UnitOfWork.Identity, Try<TransformExecutionResult>>();
    private final Provider<Directory> baseDirectory;
    private final WorkspaceProvider workspaceProvider;
    private final ExecutionHistoryStore executionHistoryStore;

    public MutableTransformWorkspaceServices(Provider<Directory> baseDirectory, ExecutionHistoryStore executionHistoryStore) {
        this.baseDirectory = baseDirectory;
        this.workspaceProvider = new MutableTransformWorkspaceProvider();
        this.executionHistoryStore = executionHistoryStore;
    }

    @Override
    public WorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    @Override
    public Cache<UnitOfWork.Identity, Try<TransformExecutionResult>> getIdentityCache() {
        return this.identityCache;
    }

    @Override
    public Provider<? extends FileSystemLocation> getReservedFileSystemLocation() {
        return this.baseDirectory;
    }

    private class MutableTransformWorkspaceProvider
    implements WorkspaceProvider {
        private MutableTransformWorkspaceProvider() {
        }

        @Override
        public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
            File workspaceDir = new File(((Directory)MutableTransformWorkspaceServices.this.baseDirectory.get()).getAsFile(), path);
            return action.executeInWorkspace(workspaceDir, MutableTransformWorkspaceServices.this.executionHistoryStore);
        }
    }
}

