/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.layout;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.descriptor.IvyRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.layout.AbstractRepositoryLayout;

public class DefaultIvyPatternRepositoryLayout
extends AbstractRepositoryLayout
implements IvyPatternRepositoryLayout {
    private final Set<String> artifactPatterns = new LinkedHashSet<String>();
    private final Set<String> ivyPatterns = new LinkedHashSet<String>();
    private boolean m2compatible;

    @Override
    public void artifact(String pattern) {
        this.artifactPatterns.add(pattern);
    }

    @Override
    public void ivy(String pattern) {
        this.ivyPatterns.add(pattern);
    }

    @Override
    public boolean getM2Compatible() {
        return this.m2compatible;
    }

    @Override
    public void setM2compatible(boolean m2compatible) {
        this.m2compatible = m2compatible;
    }

    @Override
    public void apply(@Nullable URI baseUri, IvyRepositoryDescriptor.Builder builder) {
        builder.setLayoutType("Pattern");
        builder.setM2Compatible(this.m2compatible);
        for (String pattern : this.artifactPatterns) {
            builder.addArtifactPattern(pattern);
            builder.addArtifactResource(baseUri, pattern);
        }
        for (String pattern : this.ivyPatterns) {
            builder.addIvyPattern(pattern);
        }
        Set<String> effectivePatterns = this.ivyPatterns.isEmpty() ? this.artifactPatterns : this.ivyPatterns;
        for (String pattern : effectivePatterns) {
            builder.addIvyResource(baseUri, pattern);
        }
    }
}

