/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationRole;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public final class ConfigurationRoles {
    @Deprecated
    public static final ConfigurationRole LEGACY = ConfigurationRoles.createNonDeprecatedRole("Legacy", true, true, true);
    public static final ConfigurationRole CONSUMABLE = ConfigurationRoles.createNonDeprecatedRole("Consumable", true, false, false);
    public static final ConfigurationRole RESOLVABLE = ConfigurationRoles.createNonDeprecatedRole("Resolvable", false, true, false);
    @Deprecated
    public static final ConfigurationRole RESOLVABLE_DEPENDENCY_SCOPE = ConfigurationRoles.createNonDeprecatedRole("Resolvable Dependency Scope", false, true, true);
    @Deprecated
    public static final ConfigurationRole CONSUMABLE_DEPENDENCY_SCOPE = ConfigurationRoles.createNonDeprecatedRole("Consumable Dependency Scope", true, false, true);
    public static final ConfigurationRole DEPENDENCY_SCOPE = ConfigurationRoles.createNonDeprecatedRole("Dependency Scope", false, false, true);
    private static final Set<ConfigurationRole> ALL = ImmutableSet.of((Object)LEGACY, (Object)CONSUMABLE, (Object)RESOLVABLE, (Object)RESOLVABLE_DEPENDENCY_SCOPE, (Object)CONSUMABLE_DEPENDENCY_SCOPE, (Object)DEPENDENCY_SCOPE, (Object[])new ConfigurationRole[0]);

    private ConfigurationRoles() {
    }

    private static ConfigurationRole createNonDeprecatedRole(String name, boolean consumable, boolean resolvable, boolean declarable) {
        return new DefaultConfigurationRole(name, consumable, resolvable, declarable, false, false, false);
    }

    public static Optional<ConfigurationRole> byUsage(boolean consumable, boolean resolvable, boolean declarable) {
        for (ConfigurationRole role : ALL) {
            if (role.isConsumable() != consumable || role.isResolvable() != resolvable || role.isDeclarable() != declarable) continue;
            return Optional.of(role);
        }
        return Optional.empty();
    }
}

